/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol;

import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpEntity;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpEntityEnclosingRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequestInterceptor;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpVersion;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ProtocolVersion;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.config.RequestConfig;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol.HttpClientContext;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        if (!httpRequest.containsHeader("Expect") && httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpClientContext httpClientContext;
            RequestConfig requestConfig;
            ProtocolVersion protocolVersion = httpRequest.getRequestLine().getProtocolVersion();
            HttpEntity httpEntity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
            if (httpEntity != null && httpEntity.getContentLength() != 0L && !protocolVersion.lessEquals(HttpVersion.HTTP_1_0) && (requestConfig = (httpClientContext = HttpClientContext.adapt(httpContext)).getRequestConfig()).isExpectContinueEnabled()) {
                httpRequest.addHeader("Expect", "100-continue");
            }
        }
    }
}

