/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime;

import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.ByteArrayBuffer;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.FormBodyPart;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.MIME;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.MinimalField;
import com.ibm.cognos.externals.org.apache.http_4_5_13.entity.mime.content.ContentBody;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;

abstract class AbstractMultipartForm {
    private static final ByteArrayBuffer FIELD_SEP = AbstractMultipartForm.encode(MIME.DEFAULT_CHARSET, ": ");
    private static final ByteArrayBuffer CR_LF = AbstractMultipartForm.encode(MIME.DEFAULT_CHARSET, "\r\n");
    private static final ByteArrayBuffer TWO_DASHES = AbstractMultipartForm.encode(MIME.DEFAULT_CHARSET, "--");
    final Charset charset;
    final String boundary;

    private static ByteArrayBuffer encode(Charset charset, String string) {
        ByteBuffer byteBuffer = charset.encode(CharBuffer.wrap(string));
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(byteBuffer.remaining());
        byteArrayBuffer.append(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
        return byteArrayBuffer;
    }

    private static void writeBytes(ByteArrayBuffer byteArrayBuffer, OutputStream outputStream) throws IOException {
        outputStream.write(byteArrayBuffer.buffer(), 0, byteArrayBuffer.length());
    }

    private static void writeBytes(String string, Charset charset, OutputStream outputStream) throws IOException {
        ByteArrayBuffer byteArrayBuffer = AbstractMultipartForm.encode(charset, string);
        AbstractMultipartForm.writeBytes(byteArrayBuffer, outputStream);
    }

    private static void writeBytes(String string, OutputStream outputStream) throws IOException {
        ByteArrayBuffer byteArrayBuffer = AbstractMultipartForm.encode(MIME.DEFAULT_CHARSET, string);
        AbstractMultipartForm.writeBytes(byteArrayBuffer, outputStream);
    }

    protected static void writeField(MinimalField minimalField, OutputStream outputStream) throws IOException {
        AbstractMultipartForm.writeBytes(minimalField.getName(), outputStream);
        AbstractMultipartForm.writeBytes(FIELD_SEP, outputStream);
        AbstractMultipartForm.writeBytes(minimalField.getBody(), outputStream);
        AbstractMultipartForm.writeBytes(CR_LF, outputStream);
    }

    protected static void writeField(MinimalField minimalField, Charset charset, OutputStream outputStream) throws IOException {
        AbstractMultipartForm.writeBytes(minimalField.getName(), charset, outputStream);
        AbstractMultipartForm.writeBytes(FIELD_SEP, outputStream);
        AbstractMultipartForm.writeBytes(minimalField.getBody(), charset, outputStream);
        AbstractMultipartForm.writeBytes(CR_LF, outputStream);
    }

    public AbstractMultipartForm(Charset charset, String string) {
        Args.notNull(string, "Multipart boundary");
        this.charset = charset != null ? charset : MIME.DEFAULT_CHARSET;
        this.boundary = string;
    }

    public AbstractMultipartForm(String string) {
        this(null, string);
    }

    public abstract List<FormBodyPart> getBodyParts();

    void doWriteTo(OutputStream outputStream, boolean bl2) throws IOException {
        ByteArrayBuffer byteArrayBuffer = AbstractMultipartForm.encode(this.charset, this.boundary);
        for (FormBodyPart formBodyPart : this.getBodyParts()) {
            AbstractMultipartForm.writeBytes(TWO_DASHES, outputStream);
            AbstractMultipartForm.writeBytes(byteArrayBuffer, outputStream);
            AbstractMultipartForm.writeBytes(CR_LF, outputStream);
            this.formatMultipartHeader(formBodyPart, outputStream);
            AbstractMultipartForm.writeBytes(CR_LF, outputStream);
            if (bl2) {
                formBodyPart.getBody().writeTo(outputStream);
            }
            AbstractMultipartForm.writeBytes(CR_LF, outputStream);
        }
        AbstractMultipartForm.writeBytes(TWO_DASHES, outputStream);
        AbstractMultipartForm.writeBytes(byteArrayBuffer, outputStream);
        AbstractMultipartForm.writeBytes(TWO_DASHES, outputStream);
        AbstractMultipartForm.writeBytes(CR_LF, outputStream);
    }

    protected abstract void formatMultipartHeader(FormBodyPart var1, OutputStream var2) throws IOException;

    public void writeTo(OutputStream outputStream) throws IOException {
        this.doWriteTo(outputStream, true);
    }

    public long getTotalLength() {
        long l2 = 0L;
        for (FormBodyPart object : this.getBodyParts()) {
            ContentBody contentBody = object.getBody();
            long l3 = contentBody.getContentLength();
            if (l3 >= 0L) {
                l2 += l3;
                continue;
            }
            return -1L;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.doWriteTo(byteArrayOutputStream, false);
            byte[] iOException = byteArrayOutputStream.toByteArray();
            return l2 + (long)iOException.length;
        }
        catch (IOException iOException) {
            return -1L;
        }
    }
}

