/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.auth.win;

import com.ibm.cognos.externals.org.apache.commons.logging_1_2.Log;
import com.ibm.cognos.externals.org.apache.commons.logging_1_2.LogFactory;
import com.ibm.cognos.externals.org.apache.commons_1_15.codec.binary.Base64;
import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpHost;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.message.BufferedHeader;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.CharArrayBuffer;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.AuthenticationException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.Credentials;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.InvalidCredentialsException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.MalformedChallengeException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.protocol.HttpClientContext;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.routing.RouteInfo;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.auth.AuthSchemeBase;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.auth.win.CurrentWindowsCredentials;
import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.ptr.IntByReference;

public class WindowsNegotiateScheme
extends AuthSchemeBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private final String scheme;
    private final String servicePrincipalName;
    private Sspi.CredHandle clientCred;
    private Sspi.CtxtHandle sspiContext;
    private boolean continueNeeded;
    private String challenge;

    public WindowsNegotiateScheme(String string, String string2) {
        this.scheme = string == null ? "Negotiate" : string;
        this.challenge = null;
        this.continueNeeded = true;
        this.servicePrincipalName = string2;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created WindowsNegotiateScheme using " + this.scheme);
        }
    }

    public void dispose() {
        int n2;
        if (this.clientCred != null && !this.clientCred.isNull() && 0 != (n2 = Secur32.INSTANCE.FreeCredentialsHandle(this.clientCred))) {
            throw new Win32Exception(n2);
        }
        if (this.sspiContext != null && !this.sspiContext.isNull() && 0 != (n2 = Secur32.INSTANCE.DeleteSecurityContext(this.sspiContext))) {
            throw new Win32Exception(n2);
        }
        this.continueNeeded = true;
        this.clientCred = null;
        this.sspiContext = null;
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    @Override
    public String getSchemeName() {
        return this.scheme;
    }

    @Override
    public String getParameter(String string) {
        return null;
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }

    @Override
    protected void parseChallenge(CharArrayBuffer charArrayBuffer, int n2, int n3) throws MalformedChallengeException {
        this.challenge = charArrayBuffer.substringTrimmed(n2, n3);
        if (this.challenge.isEmpty() && this.clientCred != null) {
            this.dispose();
            if (this.continueNeeded) {
                throw new RuntimeException("Unexpected token");
            }
        }
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest httpRequest, HttpContext httpContext) throws AuthenticationException {
        String string;
        Object object;
        if (this.clientCred == null) {
            if (!(credentials instanceof CurrentWindowsCredentials)) {
                throw new InvalidCredentialsException("Credentials cannot be used for " + this.getSchemeName() + " authentication: " + credentials.getClass().getName());
            }
            try {
                object = CurrentWindowsCredentials.getCurrentUsername();
                Sspi.TimeStamp timeStamp = new Sspi.TimeStamp();
                this.clientCred = new Sspi.CredHandle();
                int n2 = Secur32.INSTANCE.AcquireCredentialsHandle((String)object, this.scheme, 2, null, null, null, null, this.clientCred, timeStamp);
                if (0 != n2) {
                    throw new Win32Exception(n2);
                }
                String string2 = this.getServicePrincipalName(httpContext);
                string = this.getToken(null, null, string2);
            }
            catch (RuntimeException runtimeException) {
                this.failAuthCleanup();
                if (runtimeException instanceof Win32Exception) {
                    throw new AuthenticationException("Authentication Failed", runtimeException);
                }
                throw runtimeException;
            }
        }
        if (this.challenge == null || this.challenge.isEmpty()) {
            this.failAuthCleanup();
            throw new AuthenticationException("Authentication Failed");
        }
        try {
            object = Base64.decodeBase64(this.challenge);
            Sspi.SecBufferDesc secBufferDesc = new Sspi.SecBufferDesc(2, (byte[])object);
            String string3 = this.getServicePrincipalName(httpContext);
            string = this.getToken(this.sspiContext, secBufferDesc, string3);
        }
        catch (RuntimeException runtimeException) {
            this.failAuthCleanup();
            if (runtimeException instanceof Win32Exception) {
                throw new AuthenticationException("Authentication Failed", runtimeException);
            }
            throw runtimeException;
        }
        object = new CharArrayBuffer(this.scheme.length() + 30);
        if (this.isProxy()) {
            ((CharArrayBuffer)object).append("Proxy-Authorization");
        } else {
            ((CharArrayBuffer)object).append("Authorization");
        }
        ((CharArrayBuffer)object).append(": ");
        ((CharArrayBuffer)object).append(this.scheme);
        ((CharArrayBuffer)object).append(" ");
        ((CharArrayBuffer)object).append(string);
        return new BufferedHeader((CharArrayBuffer)object);
    }

    private void failAuthCleanup() {
        this.dispose();
        this.continueNeeded = false;
    }

    private String getServicePrincipalName(HttpContext httpContext) {
        RouteInfo routeInfo;
        HttpClientContext httpClientContext;
        HttpHost httpHost;
        HttpClientContext httpClientContext2;
        RouteInfo routeInfo2;
        String string = this.servicePrincipalName != null ? this.servicePrincipalName : (this.isProxy() ? ((routeInfo2 = (httpClientContext2 = HttpClientContext.adapt(httpContext)).getHttpRoute()) != null ? "HTTP/" + routeInfo2.getProxyHost().getHostName() : null) : ((httpHost = (httpClientContext = HttpClientContext.adapt(httpContext)).getTargetHost()) != null ? "HTTP/" + httpHost.getHostName() : ((routeInfo = httpClientContext.getHttpRoute()) != null ? "HTTP/" + routeInfo.getTargetHost().getHostName() : null)));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Using SPN: " + string);
        }
        return string;
    }

    String getToken(Sspi.CtxtHandle ctxtHandle, Sspi.SecBufferDesc secBufferDesc, String string) {
        IntByReference intByReference = new IntByReference();
        Sspi.SecBufferDesc secBufferDesc2 = new Sspi.SecBufferDesc(2, 12288);
        this.sspiContext = new Sspi.CtxtHandle();
        int n2 = Secur32.INSTANCE.InitializeSecurityContext(this.clientCred, ctxtHandle, string, 3, 0, 16, secBufferDesc, 0, this.sspiContext, secBufferDesc2, intByReference, null);
        switch (n2) {
            case 590610: {
                this.continueNeeded = true;
                break;
            }
            case 0: {
                this.dispose();
                this.continueNeeded = false;
                break;
            }
            default: {
                this.dispose();
                throw new Win32Exception(n2);
            }
        }
        return Base64.encodeBase64String(secBufferDesc2.getBytes());
    }

    @Override
    public boolean isComplete() {
        return !this.continueNeeded;
    }

    @Override
    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest httpRequest) throws AuthenticationException {
        return this.authenticate(credentials, httpRequest, null);
    }
}

