/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.client;

import com.ibm.cognos.externals.org.apache.commons.logging_1_2.Log;
import com.ibm.cognos.externals.org.apache.commons.logging_1_2.LogFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpHost;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpRequest;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpResponse;
import com.ibm.cognos.externals.org.apache.http_4_4_14.ProtocolException;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.params.HttpParams;
import com.ibm.cognos.externals.org.apache.http_4_4_14.protocol.HttpContext;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Asserts;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.CircularRedirectException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.RedirectHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.client.utils.URIUtils;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.client.RedirectLocations;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultRedirectHandler
implements RedirectHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";

    @Override
    public boolean isRedirectRequested(HttpResponse httpResponse, HttpContext httpContext) {
        Args.notNull(httpResponse, "HTTP response");
        int n2 = httpResponse.getStatusLine().getStatusCode();
        switch (n2) {
            case 301: 
            case 302: 
            case 307: {
                HttpRequest httpRequest = (HttpRequest)httpContext.getAttribute("http.request");
                String string = httpRequest.getRequestLine().getMethod();
                return string.equalsIgnoreCase("GET") || string.equalsIgnoreCase("HEAD");
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    @Override
    public URI getLocationURI(HttpResponse httpResponse, HttpContext httpContext) throws ProtocolException {
        Serializable serializable;
        Object object;
        Object object2;
        URI uRI;
        Args.notNull(httpResponse, "HTTP response");
        Header header = httpResponse.getFirstHeader("location");
        if (header == null) {
            throw new ProtocolException("Received redirect response " + httpResponse.getStatusLine() + " but no location header");
        }
        String string = header.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Redirect requested to location '" + string + "'");
        }
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ProtocolException("Invalid redirect URI: " + string, uRISyntaxException);
        }
        HttpParams httpParams = httpResponse.getParams();
        if (!uRI.isAbsolute()) {
            if (httpParams.isParameterTrue("http.protocol.reject-relative-redirect")) {
                throw new ProtocolException("Relative redirect location '" + uRI + "' not allowed");
            }
            object2 = (HttpHost)httpContext.getAttribute("http.target_host");
            Asserts.notNull(object2, "Target host");
            object = (HttpRequest)httpContext.getAttribute("http.request");
            try {
                serializable = new URI(object.getRequestLine().getUri());
                URI uRI2 = URIUtils.rewriteURI(serializable, (HttpHost)object2, URIUtils.DROP_FRAGMENT_AND_NORMALIZE);
                uRI = URIUtils.resolve(uRI2, uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ProtocolException(uRISyntaxException.getMessage(), uRISyntaxException);
            }
        }
        if (httpParams.isParameterFalse("http.protocol.allow-circular-redirects")) {
            object2 = (RedirectLocations)httpContext.getAttribute(REDIRECT_LOCATIONS);
            if (object2 == null) {
                object2 = new RedirectLocations();
                httpContext.setAttribute(REDIRECT_LOCATIONS, object2);
            }
            if (uRI.getFragment() != null) {
                try {
                    serializable = new HttpHost(uRI.getHost(), uRI.getPort(), uRI.getScheme());
                    object = URIUtils.rewriteURI(uRI, (HttpHost)serializable, URIUtils.DROP_FRAGMENT_AND_NORMALIZE);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ProtocolException(uRISyntaxException.getMessage(), uRISyntaxException);
                }
            } else {
                object = uRI;
            }
            if (((RedirectLocations)object2).contains((URI)object)) {
                throw new CircularRedirectException("Circular redirect to '" + object + "'");
            }
            ((RedirectLocations)object2).add((URI)object);
        }
        return uRI;
    }
}

