/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.client;

import com.ibm.cognos.externals.org.apache.http_4_4_14.config.Registry;
import com.ibm.cognos.externals.org.apache.http_4_4_14.config.RegistryBuilder;
import com.ibm.cognos.externals.org.apache.http_4_5_13.auth.AuthSchemeProvider;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.auth.BasicSchemeFactory;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.auth.DigestSchemeFactory;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.auth.win.WindowsCredentialsProvider;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.auth.win.WindowsNTLMSchemeFactory;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.auth.win.WindowsNegotiateSchemeFactory;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.client.CloseableHttpClient;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.client.HttpClientBuilder;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.client.SystemDefaultCredentialsProvider;
import java.util.Locale;

public class WinHttpClients {
    private WinHttpClients() {
    }

    public static boolean isWinAuthAvailable() {
        String string = System.getProperty("os.name");
        String string2 = string = string != null ? string.toLowerCase(Locale.ROOT) : null;
        if (string != null && string.contains("windows")) {
            try {
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    private static HttpClientBuilder createBuilder() {
        if (WinHttpClients.isWinAuthAvailable()) {
            Registry<AuthSchemeProvider> registry = RegistryBuilder.create().register("Basic", new BasicSchemeFactory()).register("Digest", (BasicSchemeFactory)((Object)new DigestSchemeFactory())).register("NTLM", (BasicSchemeFactory)((Object)new WindowsNTLMSchemeFactory(null))).register("Negotiate", (BasicSchemeFactory)((Object)new WindowsNegotiateSchemeFactory(null))).build();
            WindowsCredentialsProvider windowsCredentialsProvider = new WindowsCredentialsProvider(new SystemDefaultCredentialsProvider());
            return HttpClientBuilder.create().setDefaultCredentialsProvider(windowsCredentialsProvider).setDefaultAuthSchemeRegistry(registry);
        }
        return HttpClientBuilder.create();
    }

    public static HttpClientBuilder custom() {
        return WinHttpClients.createBuilder();
    }

    public static CloseableHttpClient createDefault() {
        return WinHttpClients.createBuilder().build();
    }

    public static CloseableHttpClient createSystem() {
        return WinHttpClients.createBuilder().useSystemProperties().build();
    }
}

