/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.conn;

import com.ibm.cognos.externals.org.apache.commons.logging_1_2.Log;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpClientConnection;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.pool.PoolEntry;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.ManagedHttpClientConnection;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.routing.HttpRoute;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.SAFE)
class CPoolEntry
extends PoolEntry<HttpRoute, ManagedHttpClientConnection> {
    private final Log log;
    private volatile boolean routeComplete;

    public CPoolEntry(Log log, String string, HttpRoute httpRoute, ManagedHttpClientConnection managedHttpClientConnection, long l2, TimeUnit timeUnit) {
        super(string, httpRoute, managedHttpClientConnection, l2, timeUnit);
        this.log = log;
    }

    public void markRouteComplete() {
        this.routeComplete = true;
    }

    public boolean isRouteComplete() {
        return this.routeComplete;
    }

    public void closeConnection() throws IOException {
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.getConnection();
        httpClientConnection.close();
    }

    public void shutdownConnection() throws IOException {
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.getConnection();
        httpClientConnection.shutdown();
    }

    @Override
    public boolean isExpired(long l2) {
        boolean bl2 = super.isExpired(l2);
        if (bl2 && this.log.isDebugEnabled()) {
            this.log.debug("Connection " + this + " expired @ " + new Date(this.getExpiry()));
        }
        return bl2;
    }

    @Override
    public boolean isClosed() {
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.getConnection();
        return !httpClientConnection.isOpen();
    }

    @Override
    public void close() {
        try {
            this.closeConnection();
        }
        catch (IOException iOException) {
            this.log.debug("I/O error closing connection", iOException);
        }
    }
}

