/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.conn;

import com.ibm.cognos.externals.org.apache.http_4_4_14.HttpHost;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.SchemePortResolver;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.UnsupportedSchemeException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost httpHost) throws UnsupportedSchemeException {
        Args.notNull(httpHost, "HTTP host");
        int n2 = httpHost.getPort();
        if (n2 > 0) {
            return n2;
        }
        String string = httpHost.getSchemeName();
        if (string.equalsIgnoreCase("http")) {
            return 80;
        }
        if (string.equalsIgnoreCase("https")) {
            return 443;
        }
        throw new UnsupportedSchemeException(string + " protocol is not supported");
    }
}

