/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.conn;

import com.ibm.cognos.externals.org.apache.commons.logging_1_2.Log;
import com.ibm.cognos.externals.org.apache.commons.logging_1_2.LogFactory;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_5_13.conn.DnsResolver;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryDnsResolver
implements DnsResolver {
    private final Log log = LogFactory.getLog(InMemoryDnsResolver.class);
    private final Map<String, InetAddress[]> dnsMap = new ConcurrentHashMap<String, InetAddress[]>();

    public void add(String string, InetAddress ... inetAddressArray) {
        Args.notNull(string, "Host name");
        Args.notNull(inetAddressArray, "Array of IP addresses");
        this.dnsMap.put(string, inetAddressArray);
    }

    @Override
    public InetAddress[] resolve(String string) throws UnknownHostException {
        Object[] objectArray = this.dnsMap.get(string);
        if (this.log.isInfoEnabled()) {
            this.log.info("Resolving " + string + " to " + Arrays.deepToString(objectArray));
        }
        if (objectArray == null) {
            throw new UnknownHostException(string + " cannot be resolved");
        }
        return objectArray;
    }
}

