/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie;

import com.ibm.cognos.externals.org.apache.http_4_4_14.Header;
import com.ibm.cognos.externals.org.apache.http_4_4_14.HeaderElement;
import com.ibm.cognos.externals.org.apache.http_4_4_14.NameValuePair;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Contract;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.Obsolete;
import com.ibm.cognos.externals.org.apache.http_4_4_14.annotation.ThreadingBehavior;
import com.ibm.cognos.externals.org.apache.http_4_4_14.message.BufferedHeader;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.Args;
import com.ibm.cognos.externals.org.apache.http_4_4_14.util.CharArrayBuffer;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.ClientCookie;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CommonCookieAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.Cookie;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CookieAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CookieOrigin;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.CookieRestrictionViolationException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.cookie.MalformedCookieException;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.BasicClientCookie2;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.BasicCommentHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.BasicExpiresHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.BasicMaxAgeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.BasicPathHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.BasicSecureHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2109Spec;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2965CommentUrlAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2965DiscardAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2965DomainAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2965PortAttributeHandler;
import com.ibm.cognos.externals.org.apache.http_4_5_13.impl.cookie.RFC2965VersionAttributeHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@Obsolete
@Contract(threading=ThreadingBehavior.SAFE)
public class RFC2965Spec
extends RFC2109Spec {
    public RFC2965Spec() {
        this(null, false);
    }

    public RFC2965Spec(String[] stringArray, boolean bl2) {
        super(bl2, new RFC2965VersionAttributeHandler(), new BasicPathHandler(){

            @Override
            public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
                if (!this.match(cookie, cookieOrigin)) {
                    throw new CookieRestrictionViolationException("Illegal 'path' attribute \"" + cookie.getPath() + "\". Path of origin: \"" + cookieOrigin.getPath() + "\"");
                }
            }
        }, new RFC2965DomainAttributeHandler(), new RFC2965PortAttributeHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new BasicExpiresHandler(stringArray != null ? (String[])stringArray.clone() : DATE_PATTERNS), new RFC2965CommentUrlAttributeHandler(), new RFC2965DiscardAttributeHandler());
    }

    RFC2965Spec(boolean bl2, CommonCookieAttributeHandler ... commonCookieAttributeHandlerArray) {
        super(bl2, commonCookieAttributeHandlerArray);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(header, "Header");
        Args.notNull(cookieOrigin, "Cookie origin");
        if (!header.getName().equalsIgnoreCase("Set-Cookie2")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        HeaderElement[] headerElementArray = header.getElements();
        return this.createCookies(headerElementArray, RFC2965Spec.adjustEffectiveHost(cookieOrigin));
    }

    @Override
    protected List<Cookie> parse(HeaderElement[] headerElementArray, CookieOrigin cookieOrigin) throws MalformedCookieException {
        return this.createCookies(headerElementArray, RFC2965Spec.adjustEffectiveHost(cookieOrigin));
    }

    private List<Cookie> createCookies(HeaderElement[] headerElementArray, CookieOrigin cookieOrigin) throws MalformedCookieException {
        ArrayList<Cookie> arrayList = new ArrayList<Cookie>(headerElementArray.length);
        for (HeaderElement headerElement : headerElementArray) {
            String string = headerElement.getName();
            String string2 = headerElement.getValue();
            if (string == null || string.isEmpty()) {
                throw new MalformedCookieException("Cookie name may not be empty");
            }
            BasicClientCookie2 basicClientCookie2 = new BasicClientCookie2(string, string2);
            basicClientCookie2.setPath(RFC2965Spec.getDefaultPath(cookieOrigin));
            basicClientCookie2.setDomain(RFC2965Spec.getDefaultDomain(cookieOrigin));
            basicClientCookie2.setPorts(new int[]{cookieOrigin.getPort()});
            NameValuePair[] nameValuePairArray = headerElement.getParameters();
            HashMap<String, NameValuePair> hashMap = new HashMap<String, NameValuePair>(nameValuePairArray.length);
            for (int i2 = nameValuePairArray.length - 1; i2 >= 0; --i2) {
                NameValuePair nameValuePair = nameValuePairArray[i2];
                hashMap.put(nameValuePair.getName().toLowerCase(Locale.ROOT), nameValuePair);
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                NameValuePair nameValuePair = (NameValuePair)entry.getValue();
                String string3 = nameValuePair.getName().toLowerCase(Locale.ROOT);
                basicClientCookie2.setAttribute(string3, nameValuePair.getValue());
                CookieAttributeHandler cookieAttributeHandler = this.findAttribHandler(string3);
                if (cookieAttributeHandler == null) continue;
                cookieAttributeHandler.parse(basicClientCookie2, nameValuePair.getValue());
            }
            arrayList.add(basicClientCookie2);
        }
        return arrayList;
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        super.validate(cookie, RFC2965Spec.adjustEffectiveHost(cookieOrigin));
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin cookieOrigin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(cookieOrigin, "Cookie origin");
        return super.match(cookie, RFC2965Spec.adjustEffectiveHost(cookieOrigin));
    }

    @Override
    protected void formatCookieAsVer(CharArrayBuffer charArrayBuffer, Cookie cookie, int n2) {
        String string;
        super.formatCookieAsVer(charArrayBuffer, cookie, n2);
        if (cookie instanceof ClientCookie && (string = ((ClientCookie)cookie).getAttribute("port")) != null) {
            int[] nArray;
            charArrayBuffer.append("; $Port");
            charArrayBuffer.append("=\"");
            if (!string.trim().isEmpty() && (nArray = cookie.getPorts()) != null) {
                int n3 = nArray.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (i2 > 0) {
                        charArrayBuffer.append(",");
                    }
                    charArrayBuffer.append(Integer.toString(nArray[i2]));
                }
            }
            charArrayBuffer.append("\"");
        }
    }

    private static CookieOrigin adjustEffectiveHost(CookieOrigin cookieOrigin) {
        String string = cookieOrigin.getHost();
        boolean bl2 = true;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '.' && c2 != ':') continue;
            bl2 = false;
            break;
        }
        return bl2 ? new CookieOrigin(string + ".local", cookieOrigin.getPort(), cookieOrigin.getPath(), cookieOrigin.isSecure()) : cookieOrigin;
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Header getVersionHeader() {
        CharArrayBuffer charArrayBuffer = new CharArrayBuffer(40);
        charArrayBuffer.append("Cookie2");
        charArrayBuffer.append(": ");
        charArrayBuffer.append("$Version=");
        charArrayBuffer.append(Integer.toString(this.getVersion()));
        return new BufferedHeader(charArrayBuffer);
    }

    @Override
    public String toString() {
        return "rfc2965";
    }
}

