/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1;

import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.HTMLSchema;
import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.PYXScanner;
import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.PYXWriter;
import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.Parser;
import com.ibm.cognos.externals.org.ccil.cowan.tagsoup_1_2_1.XMLWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class CommandLine {
    static Hashtable options = new Hashtable();
    private static Parser theParser;
    private static HTMLSchema theSchema;
    private static String theOutputEncoding;

    public static void main(String[] stringArray) throws IOException, SAXException {
        int n2 = CommandLine.getopts(options, stringArray);
        if (CommandLine.hasOption(options, "--help")) {
            CommandLine.doHelp();
            return;
        }
        if (CommandLine.hasOption(options, "--version")) {
            System.err.println("TagSoup version 1.2.1");
            return;
        }
        if (stringArray.length == n2) {
            CommandLine.process("", System.out);
        } else if (CommandLine.hasOption(options, "--files")) {
            for (int i2 = n2; i2 < stringArray.length; ++i2) {
                String string = stringArray[i2];
                int n3 = string.lastIndexOf(46);
                String string2 = n3 == -1 ? new StringBuffer().append(string).append(".xhtml").toString() : (string.endsWith(".xhtml") ? new StringBuffer().append(string).append("_").toString() : new StringBuffer().append(string.substring(0, n3)).append(".xhtml").toString());
                System.err.println(new StringBuffer().append("src: ").append(string).append(" dst: ").append(string2).toString());
                FileOutputStream fileOutputStream = new FileOutputStream(string2);
                CommandLine.process(string, fileOutputStream);
            }
        } else {
            for (int i3 = n2; i3 < stringArray.length; ++i3) {
                System.err.println(new StringBuffer().append("src: ").append(stringArray[i3]).toString());
                CommandLine.process(stringArray[i3], System.out);
            }
        }
    }

    private static void doHelp() {
        System.err.print("usage: java -jar tagsoup-*.jar ");
        System.err.print(" [ ");
        boolean bl2 = true;
        Enumeration enumeration = options.keys();
        while (enumeration.hasMoreElements()) {
            if (!bl2) {
                System.err.print("| ");
            }
            bl2 = false;
            String string = (String)enumeration.nextElement();
            System.err.print(string);
            if (string.endsWith("=")) {
                System.err.print("?");
            }
            System.err.print(" ");
        }
        System.err.println("]*");
    }

    private static void process(String string, OutputStream outputStream) throws IOException, SAXException {
        String string2;
        Parser parser;
        if (CommandLine.hasOption(options, "--reuse")) {
            if (theParser == null) {
                theParser = new Parser();
            }
            parser = theParser;
        } else {
            parser = new Parser();
        }
        theSchema = new HTMLSchema();
        parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", theSchema);
        if (CommandLine.hasOption(options, "--nocdata")) {
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/cdata-elements", false);
        }
        if (CommandLine.hasOption(options, "--nons") || CommandLine.hasOption(options, "--html")) {
            parser.setFeature("http://xml.org/sax/features/namespaces", false);
        }
        if (CommandLine.hasOption(options, "--nobogons")) {
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignore-bogons", true);
        }
        if (CommandLine.hasOption(options, "--any")) {
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", false);
        } else if (CommandLine.hasOption(options, "--emptybogons")) {
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", true);
        }
        if (CommandLine.hasOption(options, "--norootbogons")) {
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/root-bogons", false);
        }
        if (CommandLine.hasOption(options, "--nodefaults")) {
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/default-attributes", false);
        }
        if (CommandLine.hasOption(options, "--nocolons")) {
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/translate-colons", true);
        }
        if (CommandLine.hasOption(options, "--norestart")) {
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/restart-elements", false);
        }
        if (CommandLine.hasOption(options, "--ignorable")) {
            parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/ignorable-whitespace", true);
        }
        if (CommandLine.hasOption(options, "--pyxin")) {
            parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/scanner", new PYXScanner());
        }
        OutputStreamWriter outputStreamWriter = theOutputEncoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, theOutputEncoding);
        ContentHandler contentHandler = CommandLine.chooseContentHandler(outputStreamWriter);
        parser.setContentHandler(contentHandler);
        if (CommandLine.hasOption(options, "--lexical") && contentHandler instanceof LexicalHandler) {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", contentHandler);
        }
        InputSource inputSource = new InputSource();
        if (string != "") {
            inputSource.setSystemId(string);
        } else {
            inputSource.setByteStream(System.in);
        }
        if (CommandLine.hasOption(options, "--encoding=") && (string2 = (String)options.get("--encoding=")) != null) {
            inputSource.setEncoding(string2);
        }
        parser.parse(inputSource);
    }

    private static ContentHandler chooseContentHandler(Writer writer) {
        String string;
        if (CommandLine.hasOption(options, "--pyx")) {
            return new PYXWriter(writer);
        }
        XMLWriter xMLWriter = new XMLWriter(writer);
        if (CommandLine.hasOption(options, "--html")) {
            xMLWriter.setOutputProperty("method", "html");
            xMLWriter.setOutputProperty("omit-xml-declaration", "yes");
        }
        if (CommandLine.hasOption(options, "--method=") && (string = (String)options.get("--method=")) != null) {
            xMLWriter.setOutputProperty("method", string);
        }
        if (CommandLine.hasOption(options, "--doctype-public=") && (string = (String)options.get("--doctype-public=")) != null) {
            xMLWriter.setOutputProperty("doctype-public", string);
        }
        if (CommandLine.hasOption(options, "--doctype-system=") && (string = (String)options.get("--doctype-system=")) != null) {
            xMLWriter.setOutputProperty("doctype-system", string);
        }
        if (CommandLine.hasOption(options, "--output-encoding=") && (theOutputEncoding = (String)options.get("--output-encoding=")) != null) {
            xMLWriter.setOutputProperty("encoding", theOutputEncoding);
        }
        if (CommandLine.hasOption(options, "--omit-xml-declaration")) {
            xMLWriter.setOutputProperty("omit-xml-declaration", "yes");
        }
        xMLWriter.setPrefix(theSchema.getURI(), "");
        return xMLWriter;
    }

    private static int getopts(Hashtable hashtable, String[] stringArray) {
        int n2;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String string = stringArray[n2];
            String string2 = null;
            if (string.charAt(0) != '-') break;
            int n3 = string.indexOf(61);
            if (n3 != -1) {
                string2 = string.substring(n3 + 1, string.length());
                string = string.substring(0, n3 + 1);
            }
            if (hashtable.containsKey(string)) {
                if (string2 == null) {
                    hashtable.put(string, Boolean.TRUE);
                    continue;
                }
                hashtable.put(string, string2);
                continue;
            }
            System.err.print("Unknown option ");
            System.err.println(string);
            System.exit(1);
        }
        return n2;
    }

    private static boolean hasOption(Hashtable hashtable, String string) {
        if (Boolean.getBoolean(string)) {
            return true;
        }
        return hashtable.get(string) != Boolean.FALSE;
    }

    static {
        options.put("--nocdata", Boolean.FALSE);
        options.put("--files", Boolean.FALSE);
        options.put("--reuse", Boolean.FALSE);
        options.put("--nons", Boolean.FALSE);
        options.put("--nobogons", Boolean.FALSE);
        options.put("--any", Boolean.FALSE);
        options.put("--emptybogons", Boolean.FALSE);
        options.put("--norootbogons", Boolean.FALSE);
        options.put("--pyxin", Boolean.FALSE);
        options.put("--lexical", Boolean.FALSE);
        options.put("--pyx", Boolean.FALSE);
        options.put("--html", Boolean.FALSE);
        options.put("--method=", Boolean.FALSE);
        options.put("--doctype-public=", Boolean.FALSE);
        options.put("--doctype-system=", Boolean.FALSE);
        options.put("--output-encoding=", Boolean.FALSE);
        options.put("--omit-xml-declaration", Boolean.FALSE);
        options.put("--encoding=", Boolean.FALSE);
        options.put("--help", Boolean.FALSE);
        options.put("--version", Boolean.FALSE);
        options.put("--nodefaults", Boolean.FALSE);
        options.put("--nocolons", Boolean.FALSE);
        options.put("--norestart", Boolean.FALSE);
        options.put("--ignorable", Boolean.FALSE);
        theParser = null;
        theSchema = null;
        theOutputEncoding = null;
    }
}

