/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.ri.typed;

import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.ri.Stax2Util;
import com.ibm.cognos.externals.org.codehaus.stax2_4_2_1.typed.Base64Variant;

abstract class Base64DecoderBase {
    static final int STATE_INITIAL = 0;
    static final int STATE_VALID_1 = 1;
    static final int STATE_VALID_2 = 2;
    static final int STATE_VALID_3 = 3;
    static final int STATE_OUTPUT_3 = 4;
    static final int STATE_OUTPUT_2 = 5;
    static final int STATE_OUTPUT_1 = 6;
    static final int STATE_VALID_2_AND_PADDING = 7;
    static final int INT_SPACE = 32;
    Base64Variant _variant;
    int _state = 0;
    int _decodedData;
    Stax2Util.ByteAggregator _byteAggr = null;

    protected Base64DecoderBase() {
    }

    public abstract int decode(byte[] var1, int var2, int var3) throws IllegalArgumentException;

    public final boolean hasData() {
        return this._state >= 4 && this._state <= 6;
    }

    public final int endOfContent() {
        if (this._state == 0 || this._state == 4 || this._state == 5 || this._state == 6) {
            return 0;
        }
        if (this._variant.usesPadding()) {
            return -1;
        }
        if (this._state == 2) {
            this._state = 6;
            this._decodedData >>= 4;
            return 1;
        }
        if (this._state == 3) {
            this._decodedData >>= 2;
            this._state = 5;
            return 2;
        }
        return -1;
    }

    public byte[] decodeCompletely() {
        Stax2Util.ByteAggregator byteAggregator = this.getByteAggregator();
        byte[] byArray = byteAggregator.startAggregation();
        while (true) {
            int n2 = 0;
            int n3 = byArray.length;
            do {
                int n4;
                if ((n4 = this.decode(byArray, n2, n3)) < 1) {
                    int n5 = this.endOfContent();
                    if (n5 < 0) {
                        throw new IllegalArgumentException("Incomplete base64 triplet at the end of decoded content");
                    }
                    if (n5 > 0) continue;
                    return byteAggregator.aggregateAll(byArray, n2);
                }
                n2 += n4;
                n3 -= n4;
            } while (n3 > 0);
            byArray = byteAggregator.addFullBlock(byArray);
        }
    }

    public Stax2Util.ByteAggregator getByteAggregator() {
        if (this._byteAggr == null) {
            this._byteAggr = new Stax2Util.ByteAggregator();
        }
        return this._byteAggr;
    }

    protected IllegalArgumentException reportInvalidChar(char c2, int n2) throws IllegalArgumentException {
        return this.reportInvalidChar(c2, n2, null);
    }

    protected IllegalArgumentException reportInvalidChar(char c2, int n2, String string) throws IllegalArgumentException {
        String string2 = c2 <= ' ' ? "Illegal white space character (code 0x" + Integer.toHexString(c2) + ") as character #" + (n2 + 1) + " of 4-char base64 unit: can only used between units" : (this._variant.usesPaddingChar(c2) ? "Unexpected padding character ('" + this._variant.getPaddingChar() + "') as character #" + (n2 + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(c2) || Character.isISOControl(c2) ? "Illegal character (code 0x" + Integer.toHexString(c2) + ") in base64 content" : "Illegal character '" + c2 + "' (code 0x" + Integer.toHexString(c2) + ") in base64 content"));
        if (string != null) {
            string2 = string2 + ": " + string;
        }
        return new IllegalArgumentException(string2);
    }
}

