/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.introspector;

import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.error.YAMLException;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.introspector.GenericProperty;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.util.ArrayUtils;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

public class MethodProperty
extends GenericProperty {
    private final PropertyDescriptor property;
    private final boolean readable;
    private final boolean writable;

    private static Type discoverGenericType(PropertyDescriptor propertyDescriptor) {
        Type[] typeArray;
        Method method = propertyDescriptor.getReadMethod();
        if (method != null) {
            return method.getGenericReturnType();
        }
        Method method2 = propertyDescriptor.getWriteMethod();
        if (method2 != null && (typeArray = method2.getGenericParameterTypes()).length > 0) {
            return typeArray[0];
        }
        return null;
    }

    public MethodProperty(PropertyDescriptor propertyDescriptor) {
        super(propertyDescriptor.getName(), propertyDescriptor.getPropertyType(), MethodProperty.discoverGenericType(propertyDescriptor));
        this.property = propertyDescriptor;
        this.readable = propertyDescriptor.getReadMethod() != null;
        this.writable = propertyDescriptor.getWriteMethod() != null;
    }

    @Override
    public void set(Object object, Object object2) throws Exception {
        if (!this.writable) {
            throw new YAMLException("No writable property '" + this.getName() + "' on class: " + object.getClass().getName());
        }
        this.property.getWriteMethod().invoke(object, object2);
    }

    @Override
    public Object get(Object object) {
        try {
            this.property.getReadMethod().setAccessible(true);
            return this.property.getReadMethod().invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new YAMLException("Unable to find getter for property '" + this.property.getName() + "' on object " + object + ":" + exception);
        }
    }

    @Override
    public List<Annotation> getAnnotations() {
        List<Annotation> list = this.isReadable() && this.isWritable() ? ArrayUtils.toUnmodifiableCompositeList(this.property.getReadMethod().getAnnotations(), this.property.getWriteMethod().getAnnotations()) : (this.isReadable() ? ArrayUtils.toUnmodifiableList(this.property.getReadMethod().getAnnotations()) : ArrayUtils.toUnmodifiableList(this.property.getWriteMethod().getAnnotations()));
        return list;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        A a2 = null;
        if (this.isReadable()) {
            a2 = this.property.getReadMethod().getAnnotation(clazz);
        }
        if (a2 == null && this.isWritable()) {
            a2 = this.property.getWriteMethod().getAnnotation(clazz);
        }
        return a2;
    }

    @Override
    public boolean isWritable() {
        return this.writable;
    }

    @Override
    public boolean isReadable() {
        return this.readable;
    }
}

