/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.serializer;

import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.DumperOptions;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.comments.CommentLine;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.emitter.Emitable;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.events.AliasEvent;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.events.CommentEvent;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.events.DocumentEndEvent;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.events.DocumentStartEvent;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.events.ImplicitTuple;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.events.MappingEndEvent;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.events.MappingStartEvent;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.events.ScalarEvent;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.events.SequenceEndEvent;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.events.SequenceStartEvent;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.events.StreamEndEvent;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.events.StreamStartEvent;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.nodes.AnchorNode;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.nodes.MappingNode;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.nodes.Node;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.nodes.NodeId;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.nodes.NodeTuple;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.nodes.ScalarNode;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.nodes.SequenceNode;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.nodes.Tag;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.resolver.Resolver;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.serializer.AnchorGenerator;
import com.ibm.cognos.externals.org.yaml.snakeyaml_1_28.serializer.SerializerException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Serializer {
    private final Emitable emitter;
    private final Resolver resolver;
    private boolean explicitStart;
    private boolean explicitEnd;
    private DumperOptions.Version useVersion;
    private Map<String, String> useTags;
    private Set<Node> serializedNodes;
    private Map<Node, String> anchors;
    private AnchorGenerator anchorGenerator;
    private Boolean closed;
    private Tag explicitRoot;

    public Serializer(Emitable emitable, Resolver resolver, DumperOptions dumperOptions, Tag tag) {
        this.emitter = emitable;
        this.resolver = resolver;
        this.explicitStart = dumperOptions.isExplicitStart();
        this.explicitEnd = dumperOptions.isExplicitEnd();
        if (dumperOptions.getVersion() != null) {
            this.useVersion = dumperOptions.getVersion();
        }
        this.useTags = dumperOptions.getTags();
        this.serializedNodes = new HashSet<Node>();
        this.anchors = new HashMap<Node, String>();
        this.anchorGenerator = dumperOptions.getAnchorGenerator();
        this.closed = null;
        this.explicitRoot = tag;
    }

    public void open() throws IOException {
        if (this.closed != null) {
            if (Boolean.TRUE.equals(this.closed)) {
                throw new SerializerException("serializer is closed");
            }
            throw new SerializerException("serializer is already opened");
        }
        this.emitter.emit(new StreamStartEvent(null, null));
        this.closed = Boolean.FALSE;
    }

    public void close() throws IOException {
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (!Boolean.TRUE.equals(this.closed)) {
            this.emitter.emit(new StreamEndEvent(null, null));
            this.closed = Boolean.TRUE;
            this.serializedNodes.clear();
            this.anchors.clear();
        }
    }

    public void serialize(Node node) throws IOException {
        if (this.closed == null) {
            throw new SerializerException("serializer is not opened");
        }
        if (this.closed.booleanValue()) {
            throw new SerializerException("serializer is closed");
        }
        this.emitter.emit(new DocumentStartEvent(null, null, this.explicitStart, this.useVersion, this.useTags));
        this.anchorNode(node);
        if (this.explicitRoot != null) {
            node.setTag(this.explicitRoot);
        }
        this.serializeNode(node, null);
        this.emitter.emit(new DocumentEndEvent(null, null, this.explicitEnd));
        this.serializedNodes.clear();
        this.anchors.clear();
    }

    private void anchorNode(Node node) {
        if (node.getNodeId() == NodeId.anchor) {
            node = ((AnchorNode)node).getRealNode();
        }
        if (this.anchors.containsKey(node)) {
            String string = this.anchors.get(node);
            if (null == string) {
                string = this.anchorGenerator.nextAnchor(node);
                this.anchors.put(node, string);
            }
        } else {
            this.anchors.put(node, node.getAnchor() != null ? this.anchorGenerator.nextAnchor(node) : null);
            switch (node.getNodeId()) {
                case sequence: {
                    SequenceNode sequenceNode = (SequenceNode)node;
                    List<Node> list = sequenceNode.getValue();
                    for (Node node2 : list) {
                        this.anchorNode(node2);
                    }
                    break;
                }
                case mapping: {
                    MappingNode mappingNode = (MappingNode)node;
                    List<NodeTuple> list = mappingNode.getValue();
                    for (NodeTuple nodeTuple : list) {
                        Node node3 = nodeTuple.getKeyNode();
                        Node node4 = nodeTuple.getValueNode();
                        this.anchorNode(node3);
                        this.anchorNode(node4);
                    }
                    break;
                }
            }
        }
    }

    private void serializeNode(Node node, Node node2) throws IOException {
        if (node.getNodeId() == NodeId.anchor) {
            node = ((AnchorNode)node).getRealNode();
        }
        String string = this.anchors.get(node);
        if (this.serializedNodes.contains(node)) {
            this.emitter.emit(new AliasEvent(string, null, null));
        } else {
            this.serializedNodes.add(node);
            switch (node.getNodeId()) {
                case scalar: {
                    ScalarNode scalarNode = (ScalarNode)node;
                    this.serializeComments(node.getBlockComments());
                    Tag tag = this.resolver.resolve(NodeId.scalar, scalarNode.getValue(), true);
                    Tag tag2 = this.resolver.resolve(NodeId.scalar, scalarNode.getValue(), false);
                    ImplicitTuple implicitTuple = new ImplicitTuple(node.getTag().equals(tag), node.getTag().equals(tag2));
                    ScalarEvent scalarEvent = new ScalarEvent(string, node.getTag().getValue(), implicitTuple, scalarNode.getValue(), null, null, scalarNode.getScalarStyle());
                    this.emitter.emit(scalarEvent);
                    this.serializeComments(node.getInLineComments());
                    this.serializeComments(node.getEndComments());
                    break;
                }
                case sequence: {
                    SequenceNode sequenceNode = (SequenceNode)node;
                    this.serializeComments(node.getBlockComments());
                    boolean bl2 = node.getTag().equals(this.resolver.resolve(NodeId.sequence, null, true));
                    this.emitter.emit(new SequenceStartEvent(string, node.getTag().getValue(), bl2, null, null, sequenceNode.getFlowStyle()));
                    List<Node> list = sequenceNode.getValue();
                    for (Node node3 : list) {
                        this.serializeNode(node3, node);
                    }
                    this.emitter.emit(new SequenceEndEvent(null, null));
                    this.serializeComments(node.getInLineComments());
                    this.serializeComments(node.getEndComments());
                    break;
                }
                default: {
                    this.serializeComments(node.getBlockComments());
                    Tag tag = this.resolver.resolve(NodeId.mapping, null, true);
                    boolean bl3 = node.getTag().equals(tag);
                    MappingNode mappingNode = (MappingNode)node;
                    List<NodeTuple> list = mappingNode.getValue();
                    if (mappingNode.getTag() == Tag.COMMENT) break;
                    this.emitter.emit(new MappingStartEvent(string, mappingNode.getTag().getValue(), bl3, null, null, mappingNode.getFlowStyle()));
                    for (NodeTuple nodeTuple : list) {
                        Node node4 = nodeTuple.getKeyNode();
                        Node node5 = nodeTuple.getValueNode();
                        this.serializeNode(node4, mappingNode);
                        this.serializeNode(node5, mappingNode);
                    }
                    this.emitter.emit(new MappingEndEvent(null, null));
                    this.serializeComments(node.getInLineComments());
                    this.serializeComments(node.getEndComments());
                }
            }
        }
    }

    private void serializeComments(List<CommentLine> list) throws IOException {
        if (list == null) {
            return;
        }
        for (CommentLine commentLine : list) {
            CommentEvent commentEvent = new CommentEvent(commentLine.getCommentType(), commentLine.getValue(), commentLine.getStartMark(), commentLine.getEndMark());
            this.emitter.emit(commentEvent);
        }
    }
}

