/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api;

import com.ibm.cognos.aurora.api.query.IQueryLogicalStorage;
import java.util.Properties;

public final class QLSAPI {
    public static final String PROPKEY_QLS_CLASSNAME = "aurora.qls.class";
    private static final String DEFAULT_IMPL_CLASSNAME = "com.ibm.cognos.aurora.qls.query.QueryLogicalStorageImpl";

    public static IQueryLogicalStorage getInstance(Properties props) {
        String qlsClassName = props.getProperty(PROPKEY_QLS_CLASSNAME);
        if (qlsClassName == null) {
            qlsClassName = DEFAULT_IMPL_CLASSNAME;
        }
        return QLSAPI.getInstance(qlsClassName, props);
    }

    public static IQueryLogicalStorage getInstance(String implClassName, Properties props) {
        IQueryLogicalStorage instance;
        if (null == props) {
            throw new IllegalArgumentException("props was null");
        }
        try {
            Class<?> implClass = Class.forName(implClassName);
            instance = (IQueryLogicalStorage)implClass.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to load implementation class.", ex);
        }
        instance.initialize(props);
        return instance;
    }
}

