/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model;

public enum EAggregateType {
    AVERAGE("average"),
    COUNT("count"),
    COUNT_DISTINCT("countDistinct"),
    FIRST("firstPeriod"),
    LAST("lastPeriod"),
    MAXIMUM("maximum"),
    MEDIAN("median"),
    MINIMUM("minimum"),
    NONE("none"),
    SUM("sum"),
    SUPPRESS("suppress"),
    STDDEV("stddev"),
    VARIANCE("variance");

    private final String keyword;

    private EAggregateType(String keyword) {
        this.keyword = keyword;
    }

    public static EAggregateType getAggregate(String aggregateType) {
        for (EAggregateType e : EAggregateType.values()) {
            if (!e.toString().equals(aggregateType)) continue;
            return e;
        }
        if (aggregateType.equals("count distinct")) {
            return COUNT_DISTINCT;
        }
        if (aggregateType.equals("stddev")) {
            return STDDEV;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return this.keyword;
    }

    public static EAggregateType valueOfMetricAggregate(String metricAggregate) {
        if (metricAggregate.equals("average")) {
            return AVERAGE;
        }
        if (metricAggregate.equals("count")) {
            return COUNT;
        }
        if (metricAggregate.equals("sum")) {
            return SUM;
        }
        throw new IllegalArgumentException();
    }
}

