/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.datatype;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.datatype.NumericType;
import com.ibm.cognos.aurora.api.model.value.DecimalValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.dom4j.Element;

public class DecimalType
extends NumericType
implements IDataType {
    public static final int MIN_PRECISION = 1;
    public static final int MAX_PRECISION = 256;
    public static final int MAX_CACHED_PRECISION = 256;
    public static final int MAX_SPECIALIZED_PRECISION = 18;
    public static final int MIN_SCALE = -256;
    public static final int DEFAULT_PRECISION = 256;
    public static final int DEFAULT_SCALE = 2;
    private int mPrecision;
    private int mScale;

    public DecimalType() {
        this(256, 2);
    }

    public DecimalType(int precision) {
        this(precision, 2);
    }

    public DecimalType(int precision, int scale) {
        DecimalType.validatePrecisionAndScale(precision, scale);
        this.mPrecision = precision;
        this.mScale = scale;
    }

    private static void validatePrecisionAndScale(int precision, int scale) {
        boolean isUnlimitedUpperBoundry;
        boolean bl = isUnlimitedUpperBoundry = precision == Integer.MAX_VALUE;
        if (precision < 1 || precision > 256 && !isUnlimitedUpperBoundry || scale < -256 || scale > precision) {
            String msg = String.format("Invalid decimal type with precision (%d) and scale (%d).", precision, scale);
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public BaseDataType getBaseType() {
        return BaseDataType.DECIMAL;
    }

    public int getPrecision() {
        return this.mPrecision;
    }

    public int getScale() {
        return this.mScale;
    }

    public DecimalType withPrecisionAndScale(int precision, int scale) {
        if (precision == this.mPrecision && scale == this.mScale) {
            return this;
        }
        return new DecimalType(precision, scale);
    }

    @Override
    public boolean isExactNumeric() {
        return true;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public IValue newValue() {
        return new DecimalValue(this);
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        out.writeShort(this.mPrecision);
        out.writeShort(this.mScale);
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mPrecision = in.readShort();
        this.mScale = in.readShort();
        DecimalType.validatePrecisionAndScale(this.mPrecision, this.mScale);
    }

    @Override
    public void encodeElement(Element elem, EncoderContext ctx) {
        elem.addAttribute("precision", Integer.toString(this.mPrecision));
        elem.addAttribute("scale", Integer.toString(this.mScale));
    }

    @Override
    public void decodeElement(Element elem, EncoderContext ctx) {
        this.mPrecision = Integer.parseInt(elem.attributeValue("precision"));
        this.mScale = Integer.parseInt(elem.attributeValue("scale"));
        DecimalType.validatePrecisionAndScale(this.mPrecision, this.mScale);
    }

    public String toString() {
        return String.format("decimal(%d, %d)", this.mPrecision, this.mScale);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DecimalType)) {
            return false;
        }
        DecimalType other = (DecimalType)o;
        return this.mPrecision == other.mPrecision && this.mScale == other.mScale;
    }

    public int hashCode() {
        return this.getBaseType().hashCode() + this.mPrecision + this.mScale;
    }
}

