/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.datatype;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.StringValue;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.dom4j.Element;

public class StringType
implements IDataType {
    private int mMaxLength;

    public StringType(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxLength must be > 0");
        }
        this.mMaxLength = maxLength;
    }

    StringType() {
        this.mMaxLength = Integer.MAX_VALUE;
    }

    @Override
    public BaseDataType getBaseType() {
        return BaseDataType.STRING;
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public boolean isExactNumeric() {
        return false;
    }

    @Override
    public boolean isInteger() {
        return false;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean isTemporal() {
        return false;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    public int getMaxLength() {
        return this.mMaxLength;
    }

    public StringType withMaxLength(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("maxLength must be > 0");
        }
        if (maxLength == this.mMaxLength) {
            return this;
        }
        return new StringType(maxLength);
    }

    @Override
    public IValue newValue() {
        return new StringValue(this);
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        EncodeUtil.writeCompressedInt(out, this.mMaxLength);
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mMaxLength = EncodeUtil.readCompressedInt(in);
    }

    @Override
    public void encodeElement(Element elem, EncoderContext ctx) {
        elem.addAttribute("maxLength", Integer.toString(this.mMaxLength));
    }

    @Override
    public void decodeElement(Element elem, EncoderContext ctx) {
        this.mMaxLength = Integer.parseInt(elem.attributeValue("maxLength"));
    }

    public String toString() {
        return "string(" + this.mMaxLength + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StringType)) {
            return false;
        }
        StringType other = (StringType)o;
        return this.mMaxLength == other.mMaxLength;
    }

    public int hashCode() {
        return this.getBaseType().hashCode() + this.mMaxLength;
    }
}

