/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.facet;

import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.facet.IFacetValue;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IOperator;
import java.util.ArrayList;
import java.util.List;

public class FacetSelection {
    protected IAttribute[] facet;
    protected List<IFacetValue> includedFacetValues;
    protected List<IFacetValue> excludedFacetValues;
    protected IValue fromFacetValue;
    protected IValue toFacetValue;
    protected boolean containsRange = false;
    protected boolean invert;
    protected IOperator filterCondition = null;

    public FacetSelection(IAttribute[] facet) {
        this(facet, null);
    }

    public FacetSelection(IAttribute[] facet, IOperator filterCondition) {
        this.facet = facet;
        this.includedFacetValues = null;
        this.excludedFacetValues = null;
        this.setFilterCondition(filterCondition);
        this.invert = false;
    }

    public void setIncludedFacetValues(List<IFacetValue> values) {
        this.includedFacetValues = values;
        this.containsRange = false;
    }

    public List<IFacetValue> getIncludedFacetValues() {
        return this.includedFacetValues;
    }

    public void addIncludedFacetValue(IFacetValue facetValue) {
        if (this.includedFacetValues == null) {
            this.includedFacetValues = new ArrayList<IFacetValue>();
        }
        this.includedFacetValues.add(facetValue);
        this.containsRange = false;
    }

    public void setExcludedFacetValues(List<IFacetValue> values) {
        this.excludedFacetValues = values;
    }

    public List<IFacetValue> getExcludedFacetValues() {
        return this.excludedFacetValues;
    }

    public void addExcludedFacetValue(IFacetValue facetValue) {
        if (this.excludedFacetValues == null) {
            this.excludedFacetValues = new ArrayList<IFacetValue>();
        }
        this.excludedFacetValues.add(facetValue);
    }

    public void setRange(IValue from, IValue to) {
        if (this.facet.length > 1) {
            throw new IllegalStateException();
        }
        this.fromFacetValue = from;
        this.toFacetValue = to;
        this.containsRange = true;
    }

    public IAttribute[] getFacetAttributes() {
        return this.facet;
    }

    public boolean containsRange() {
        return this.containsRange;
    }

    public IOperator getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(IOperator condition) {
        this.filterCondition = condition;
    }

    public boolean containsCondition() {
        return this.filterCondition != null;
    }

    public IValue getRangeStartFacetValue() {
        if (!this.containsRange()) {
            throw new IllegalStateException();
        }
        return this.fromFacetValue;
    }

    public IValue getRangeEndFacetValue() {
        if (!this.containsRange()) {
            throw new IllegalStateException();
        }
        return this.toFacetValue;
    }

    public void setInvert(boolean _invert) {
        this.invert = _invert;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public boolean isEmpty() {
        if (this.filterCondition != null) {
            return false;
        }
        if (this.includedFacetValues != null && this.includedFacetValues.size() > 0) {
            return false;
        }
        if (this.excludedFacetValues != null && this.excludedFacetValues.size() > 0) {
            return false;
        }
        if (this.containsRange()) {
            return false;
        }
        if (this.invert) {
            return false;
        }
        return !this.invert;
    }

    public boolean doesIncludedValuesContainNull() {
        return this.doesListContainNull(this.includedFacetValues);
    }

    public boolean doesExcludedValuesContainNull() {
        return this.doesListContainNull(this.excludedFacetValues);
    }

    private boolean doesListContainNull(List<IFacetValue> facetValues) {
        if (facetValues == null) {
            return false;
        }
        for (IFacetValue facetValue : facetValues) {
            if (!facetValue.isNullValue()) continue;
            return true;
        }
        return false;
    }
}

