/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.join;

import com.ibm.cognos.aurora.api.model.IAttribute;
import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelColumn;
import com.ibm.cognos.aurora.api.model.physical.rel.IRelTable;

public class DataItemPair {
    private IDataItem[] dataItems = new IDataItem[]{null, null};
    private IAttribute[] attributes = new IAttribute[]{null, null};

    public DataItemPair(IDataItem leftDataItem, IDataItem rightDataItem) {
        this.dataItems[Side.LEFT.ordinal()] = leftDataItem;
        this.dataItems[Side.RIGHT.ordinal()] = rightDataItem;
    }

    public DataItemPair(IAttribute leftAttribute, IAttribute rightAttribute) {
        this.attributes[Side.LEFT.ordinal()] = leftAttribute;
        this.attributes[Side.RIGHT.ordinal()] = rightAttribute;
    }

    public IDataItem getLeftDataItem() {
        return this.getDataItem(Side.LEFT);
    }

    public IDataItem getRightDataItem() {
        return this.getDataItem(Side.RIGHT);
    }

    public IAttribute getAttribute(Side side) {
        return this.attributes[side.ordinal()];
    }

    public IRelTable getTable(Side side) {
        IAttribute attribute = this.getAttribute(side);
        if (attribute != null && attribute.isDerived()) {
            return (IRelTable)this.getDataItem(side).getContainer().getPhysicalMetadata();
        }
        if (this.getColumn(side) != null) {
            return this.getColumn(side).getTable();
        }
        return null;
    }

    public String getDescription(Side side) {
        String desc = side.toString();
        desc = this.getAttribute(side) != null ? desc + " attribute " + this.getAttribute(side).getCaption() + " (uniqueName: " + this.getAttribute(side).getUniqueName() + ", " : desc + " DataItem " + this.getDataItem(side).getName() + " (";
        desc = desc + "table: " + this.getTable(side).getTableName() + ")";
        return desc;
    }

    private IDataItem getDataItem(Side side) {
        IAttribute attribute = this.getAttribute(side);
        if (attribute != null) {
            return attribute.getNode().getDataItem();
        }
        return this.dataItems[side.ordinal()];
    }

    private IRelColumn getColumn(Side side) {
        return (IRelColumn)this.getDataItem(side).getPhysicalMetadata();
    }

    public static enum Side {
        LEFT("left"),
        RIGHT("right");

        private final String name;

        private Side(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

