/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.DecimalType;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueBase;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Date;

public class DecimalValue
extends ValueBase {
    private final DecimalType mType;
    private BigDecimal mValue;

    public DecimalValue() {
        this(DataTypes.getDecimalType());
    }

    public DecimalValue(DecimalType type) {
        this.mType = type;
        this.setStatus(ValueStatus.NULL);
    }

    public DecimalValue(BigDecimal value) {
        if (null == value) {
            this.mType = DataTypes.getDecimalType();
            this.set(null);
        } else {
            this.mType = DataTypes.getDecimalType(Math.max(value.precision(), value.scale()), value.scale());
            this.set(value);
        }
    }

    public DecimalValue(DecimalType type, BigDecimal value) {
        this.mType = type;
        this.set(value);
    }

    @Override
    public IDataType getType() {
        return this.mType;
    }

    public void set(BigDecimal value, ValueStatus status) {
        this.mValue = null == value ? null : DecimalValue.cast(value, this.mType.getPrecision(), this.mType.getScale(), RoundingMode.HALF_DOWN);
        this.setStatus(status);
    }

    public void set(BigDecimal value) {
        if (null == value) {
            this.set(null, ValueStatus.NULL);
        } else {
            this.set(value, ValueStatus.OK);
        }
    }

    @Override
    public Object objectValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.mValue;
    }

    @Override
    public String stringValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.mValue.toPlainString();
    }

    @Override
    public float floatValue() {
        if (!this.isOK() || null == this.mValue) {
            return 0.0f;
        }
        return this.mValue.floatValue();
    }

    @Override
    public double doubleValue() {
        if (!this.isOK() || null == this.mValue) {
            return 0.0;
        }
        return this.mValue.doubleValue();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (!this.isOK()) {
            return null;
        }
        if (null == this.mValue) {
            return DecimalValue.cast(BigDecimal.ZERO, this.mType.getPrecision(), this.mType.getScale(), RoundingMode.HALF_DOWN);
        }
        return this.mValue;
    }

    @Override
    public int intValue() {
        if (!this.isOK() || null == this.mValue) {
            return 0;
        }
        return this.mValue.intValue();
    }

    @Override
    public long longValue() {
        if (!this.isOK() || null == this.mValue) {
            return 0L;
        }
        return this.mValue.longValue();
    }

    @Override
    public Date dateValue() {
        if (!this.isOK()) {
            return null;
        }
        return new Date(this.longValue());
    }

    @Override
    public boolean booleanValue() {
        return 0 != this.intValue();
    }

    public int hashCode() {
        int hc = this.getStatus().hashCode();
        if (null != this.mValue) {
            hc = this.mValue.hashCode();
        }
        return hc;
    }

    @Override
    public int compareTo(IValue other) {
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (other.getType().getBaseType() != BaseDataType.DECIMAL) {
            return DecimalValue.compareValue(this, other);
        }
        int c = DecimalValue.compareStatus(this.getStatus(), other.getStatus());
        if (0 != c) {
            return c;
        }
        BigDecimal leftValue = this.bigDecimalValue();
        BigDecimal rightValue = other.bigDecimalValue();
        if (null == leftValue) {
            if (null == rightValue) {
                return 0;
            }
            return -1;
        }
        if (null == rightValue) {
            return 1;
        }
        return leftValue.compareTo(rightValue);
    }

    @Override
    public void assignFrom(IValue value) {
        if (null == value || ValueStatus.NULL == value.getStatus()) {
            this.set(null, ValueStatus.NULL);
        } else {
            this.set(value.bigDecimalValue(), value.getStatus());
        }
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set(null, ValueStatus.NULL);
        } else {
            try {
                this.set(new BigDecimal(value), ValueStatus.OK);
            }
            catch (NumberFormatException ex) {
                this.setError();
            }
        }
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        super.encodeBinary(out, ctx);
        if (this.getStatus() == ValueStatus.OK) {
            byte[] data = this.mValue.unscaledValue().toByteArray();
            out.writeInt(data.length);
            out.write(data);
        }
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        super.decodeBinary(in, ctx);
        if (this.getStatus() == ValueStatus.OK) {
            byte[] data = new byte[in.readInt()];
            in.readFully(data);
            this.mValue = new BigDecimal(new BigInteger(data), this.mType.getScale());
        }
    }

    @Override
    public Number numberValue() {
        return this.bigDecimalValue();
    }

    protected static BigDecimal cast(BigDecimal aBigDecimal, int newPrecision, int newScale, RoundingMode roundingMode) {
        int scale = aBigDecimal.scale();
        int precision = aBigDecimal.precision();
        if (precision == newPrecision && scale == newScale) {
            return aBigDecimal;
        }
        if (precision == newPrecision) {
            return aBigDecimal.setScale(newScale, roundingMode);
        }
        BigDecimal newValue = new BigDecimal(aBigDecimal.unscaledValue(), scale, new MathContext(newPrecision));
        if (scale == newScale) {
            return newValue;
        }
        return newValue.setScale(newScale, roundingMode);
    }
}

