/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueBase;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;

public class FloatValue
extends ValueBase {
    private float mValue;

    public FloatValue() {
        this.setStatus(ValueStatus.NULL);
    }

    public FloatValue(float value, ValueStatus status) {
        this.set(value, status);
    }

    public FloatValue(float value) {
        this.set(value);
    }

    @Override
    public IDataType getType() {
        return DataTypes.getFloatType();
    }

    public void set(float value, ValueStatus status) {
        this.mValue = value;
        this.setStatus(status);
    }

    public void set(float value) {
        this.set(value, ValueStatus.OK);
    }

    public void set(Float value) {
        if (null == value) {
            this.set(0.0f, ValueStatus.NULL);
        } else {
            this.set(value.floatValue(), ValueStatus.OK);
        }
    }

    @Override
    public Object objectValue() {
        if (this.isNull()) {
            return null;
        }
        return Float.valueOf(this.mValue);
    }

    @Override
    public String stringValue() {
        if (this.isNull()) {
            return null;
        }
        return Float.toString(this.mValue);
    }

    @Override
    public float floatValue() {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.mValue;
    }

    @Override
    public double doubleValue() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.mValue;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (!this.isOK() || Float.isInfinite(this.mValue) || Float.isNaN(this.mValue)) {
            return null;
        }
        return new BigDecimal(this.mValue);
    }

    @Override
    public int intValue() {
        if (!this.isOK()) {
            return 0;
        }
        return (int)this.mValue;
    }

    @Override
    public long longValue() {
        if (!this.isOK()) {
            return 0L;
        }
        return (long)this.mValue;
    }

    @Override
    public Date dateValue() {
        if (!this.isOK()) {
            return null;
        }
        return new Date(this.longValue());
    }

    @Override
    public boolean booleanValue() {
        if (!this.isOK()) {
            return false;
        }
        return 0.0f != this.mValue;
    }

    public int hashCode() {
        return this.getStatus().hashCode() + Float.floatToIntBits(this.mValue);
    }

    @Override
    public int compareTo(IValue other) {
        float rightValue;
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (other.getType().getBaseType() != BaseDataType.FLOAT) {
            return FloatValue.compareValue(this, other);
        }
        int c = FloatValue.compareStatus(this.getStatus(), other.getStatus());
        if (0 != c) {
            return c;
        }
        float leftValue = this.floatValue();
        if (leftValue < (rightValue = other.floatValue())) {
            return -1;
        }
        if (leftValue > rightValue) {
            return 1;
        }
        return 0;
    }

    @Override
    public void assignFrom(IValue value) {
        if (null == value || ValueStatus.NULL == value.getStatus()) {
            this.set(0.0f, ValueStatus.NULL);
        } else {
            this.set(value.floatValue(), value.getStatus());
        }
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set(0.0f, ValueStatus.NULL);
        } else {
            try {
                this.set(Float.parseFloat(value), ValueStatus.OK);
            }
            catch (NumberFormatException ex) {
                this.setError();
            }
        }
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        super.encodeBinary(out, ctx);
        if (this.getStatus() == ValueStatus.OK) {
            out.writeFloat(this.mValue);
        }
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        super.decodeBinary(in, ctx);
        if (this.getStatus() == ValueStatus.OK) {
            this.mValue = in.readFloat();
        }
    }

    @Override
    public Number numberValue() {
        if (this.isOK()) {
            return Float.valueOf(this.floatValue());
        }
        return null;
    }
}

