/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueBase;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;

public class ObjectValue
extends ValueBase {
    private Object mValue;

    public ObjectValue() {
        this.setStatus(ValueStatus.NULL);
    }

    public ObjectValue(Object value) {
        this.set(value);
    }

    public ObjectValue(Object value, ValueStatus status) {
        this.set(value, status);
    }

    @Override
    public IDataType getType() {
        return DataTypes.getObjectType();
    }

    public void set(Object value, ValueStatus status) {
        this.mValue = value;
        this.setStatus(status);
    }

    public void set(Object value) {
        if (null == value) {
            this.set(null, ValueStatus.NULL);
        } else {
            this.set(value, ValueStatus.OK);
        }
    }

    @Override
    public Object objectValue() {
        if (!this.isOK()) {
            return null;
        }
        return this.mValue;
    }

    @Override
    public Number numberValue() {
        return null;
    }

    @Override
    public String stringValue() {
        if (!this.isOK()) {
            return null;
        }
        return String.valueOf(this.mValue);
    }

    @Override
    public float floatValue() {
        return 0.0f;
    }

    @Override
    public double doubleValue() {
        return 0.0;
    }

    @Override
    public int intValue() {
        return 0;
    }

    @Override
    public long longValue() {
        return 0L;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (!this.isOK()) {
            return null;
        }
        return BigDecimal.ZERO;
    }

    @Override
    public Date dateValue() {
        if (!this.isOK()) {
            return null;
        }
        return DELINQUENT_DATE;
    }

    @Override
    public boolean booleanValue() {
        return false;
    }

    public int hashCode() {
        if (this.mValue == null) {
            return this.getStatus().hashCode();
        }
        return this.getStatus().hashCode() + this.mValue.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IValue)) {
            return false;
        }
        int c = ObjectValue.compareStatus(this.getStatus(), ((IValue)o).getStatus());
        if (0 != c) {
            return false;
        }
        Object thisValue = this.objectValue();
        Object otherValue = ((IValue)o).objectValue();
        if (null == thisValue) {
            return null == otherValue;
        }
        if (null == otherValue) {
            return false;
        }
        return thisValue.equals(otherValue);
    }

    @Override
    public int compareTo(IValue other) {
        if (this == other) {
            return 0;
        }
        if (null == other) {
            return 1;
        }
        if (other.getType().getBaseType() != BaseDataType.OBJECT) {
            return ObjectValue.compareValue(this, other);
        }
        int c = ObjectValue.compareStatus(this.getStatus(), other.getStatus());
        if (0 != c) {
            return c;
        }
        if (other.getType().isObject() && this.objectValue() instanceof Comparable) {
            return ((Comparable)this.objectValue()).compareTo(other.objectValue());
        }
        return -1;
    }

    @Override
    public void assignFrom(IValue value) {
        if (null == value || ValueStatus.NULL == value.getStatus()) {
            this.set(null, ValueStatus.NULL);
        } else {
            this.set(value.objectValue(), value.getStatus());
        }
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set(null, ValueStatus.NULL);
        } else {
            this.set(value, ValueStatus.OK);
        }
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        throw new UnsupportedOperationException();
    }
}

