/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value;

import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.DateTimeValue;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimestampValue
extends DateTimeValue {
    private static final Pattern PATTERN = Pattern.compile("[0-9]{1,4}+-[0-9]{1,2}+-[0-9]{1,2}+(\\s|T)[0-9]{1,2}+:[0-9]{1,2}+:[0-9]{1,2}+(\\.[0-9]{1,9}+)?((\\+|-)[0-9]{1,2}+(:[0-9]{1,2}+)?)?");

    public TimestampValue() {
    }

    public TimestampValue(TimeZone tz) {
        super(tz);
    }

    public TimestampValue(Date dt) {
        super(dt);
    }

    public TimestampValue(Date dt, TimeZone tz) {
        super(dt, tz);
    }

    public TimestampValue(Calendar cal) {
        super(cal);
    }

    @Override
    public IDataType getType() {
        return DataTypes.getTimestampType();
    }

    @Override
    public void assignFrom(String value) {
        if (null == value) {
            this.set((Date)null, ValueStatus.NULL);
            return;
        }
        Matcher m = PATTERN.matcher(value);
        if (!m.matches()) {
            this.set((Date)null, ValueStatus.ERROR);
            return;
        }
        String[] list = value.replace('T', ' ').split(" ");
        String[] dateFields = list[0].split("-");
        int year = Integer.parseInt(dateFields[0]);
        int month = Integer.parseInt(dateFields[1]);
        int day = Integer.parseInt(dateFields[2]);
        int sign = 1;
        if (list[1].indexOf("-") > 0) {
            sign = -1;
        }
        list = list[1].split("\\+|-");
        String[] timeFields = list[0].split(":");
        int hour = Integer.parseInt(timeFields[0]);
        int minute = Integer.parseInt(timeFields[1]);
        timeFields = timeFields[2].split("\\.");
        int second = Integer.parseInt(timeFields[0]);
        int nanoseconds = 0;
        if (timeFields.length > 1) {
            StringBuilder tmpBuf = new StringBuilder(timeFields[1]);
            tmpBuf.append(ZEROS[9 - timeFields[1].length()]);
            nanoseconds = Integer.parseInt(tmpBuf.toString());
        }
        if (list.length > 1) {
            String[] timeZoneFields = list[1].split(":");
            int tzHour = Integer.parseInt(timeZoneFields[0]);
            int tzMinute = 0;
            if (timeZoneFields.length == 2) {
                tzMinute = Integer.parseInt(timeZoneFields[1]);
            }
            int rawOffset = (tzHour * 3600000 + tzMinute * 60000) * sign;
            this.setTimeZone(TimestampValue.getTimeZoneFromRawOffset(rawOffset));
        }
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
        this.setMillisecond(nanoseconds / 1000000);
        this.setOK();
    }

    @Override
    public void set(Date dt, TimeZone tz, ValueStatus status) {
        super.set(dt, tz, status);
    }

    @Override
    public String stringValue() {
        if (!this.isOK()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.getMillisecond() > 0) {
            sb.append(String.format("%1$4d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d.%7$09d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), 1000000 * this.getMillisecond()));
        } else {
            sb.append(String.format("%1$04d-%2$02d-%3$02d %4$02d:%5$02d:%6$02d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond()));
        }
        sb.append(this.convertTimeZoneToString());
        return sb.toString();
    }

    @Override
    public String stringValueISO8601NoTimezone() {
        if (!this.isOK()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.getMillisecond() > 0) {
            sb.append(String.format("%1$4d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02d.%7$03d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond(), 1000000 * this.getMillisecond()));
        } else {
            sb.append(String.format("%1$04d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02d", this.getYear(), this.getMonth(), this.getDay(), this.getHour(), this.getMinute(), this.getSecond()));
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        if (this.isNull()) {
            return Integer.MIN_VALUE;
        }
        if (this.isError()) {
            return Integer.MAX_VALUE;
        }
        long millis = this.getTimeInMillis();
        return (int)(millis ^ millis >>> 32);
    }
}

