/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value;

import com.ibm.cognos.aurora.api.format.IValueFormat;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueStatus;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.cognos.aurora.core.model.ICUformat.FormatProperties;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Date;
import org.dom4j.Element;

public abstract class ValueBase
implements IValue {
    protected static final ILogger logger = LoggerManager.getLogger("ATHENA.core.aurora_core");
    protected static final Date DELINQUENT_DATE = new Date(0L);
    private ValueStatus mStatus = ValueStatus.NULL;
    private String mFormattedValue;
    private IValueFormat mFormatter;
    private FormatProperties mFormatProperties;

    @Override
    public final ValueStatus getStatus() {
        return this.mStatus;
    }

    @Override
    public void setStatus(ValueStatus status) {
        this.mStatus = status;
    }

    @Override
    public void setOK() {
        this.setStatus(ValueStatus.OK);
    }

    @Override
    public void setNull() {
        this.setStatus(ValueStatus.NULL);
    }

    @Override
    public void setDivByZero() {
        this.setStatus(ValueStatus.DIVBYZERO);
    }

    @Override
    public void setError() {
        this.setStatus(ValueStatus.ERROR);
    }

    @Override
    public boolean isDivByZero() {
        return ValueStatus.DIVBYZERO == this.mStatus;
    }

    @Override
    public boolean isNull() {
        return ValueStatus.NULL == this.mStatus;
    }

    @Override
    public boolean isError() {
        return ValueStatus.ERROR == this.mStatus;
    }

    @Override
    public boolean isOK() {
        return ValueStatus.OK == this.mStatus;
    }

    public String toString() {
        if (this.isNull()) {
            return "#null#";
        }
        if (this.isError()) {
            return "#error#";
        }
        if (this.isDivByZero()) {
            return "#divbyzero#";
        }
        return this.stringValue();
    }

    @Override
    public void encodeElement(Element elem, EncoderContext ctx) {
        elem.addAttribute("status", this.mStatus.name());
        if (this.mStatus == ValueStatus.OK) {
            elem.addElement("data").setText(this.toString());
        }
    }

    @Override
    public void decodeElement(Element elem, EncoderContext ctx) {
        this.mStatus = ValueStatus.valueOf(elem.attributeValue("status"));
        if (this.mStatus == ValueStatus.OK) {
            this.assignFrom(elem.elementText("data"));
        }
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        out.writeByte(this.mStatus.ordinal());
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mStatus = ValueStatus.values()[in.readByte()];
    }

    @Override
    public String getFormatString() {
        if (null == this.mFormatter) {
            return null;
        }
        return this.mFormatter.getDsFormatString();
    }

    @Override
    public void setFormattedValue(String fValue) {
        this.mFormattedValue = fValue;
    }

    @Override
    public String getFormattedValue() {
        if (this.mFormattedValue == null) {
            if (this.mFormatter != null) {
                try {
                    this.setFormattedValue(this.mFormatter.format(this));
                }
                catch (Exception ex) {
                    logger.error("Caught exception when trying to format value (" + this.stringValue() + ") with formatter " + this.mFormatter.getClass(), this.getClass().getName() + "::getFormattedValue()", ex);
                    this.setFormattedValue(this.stringValue());
                }
            } else {
                this.setFormattedValue(this.stringValue());
            }
        }
        return this.mFormattedValue;
    }

    @Override
    public IValueFormat getFormatter() {
        return this.mFormatter;
    }

    @Override
    public void setFormatter(IValueFormat _formatter) {
        this.mFormatter = _formatter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IValue)) {
            return false;
        }
        return 0 == this.compareTo((IValue)o);
    }

    public Object clone() {
        IValue clone = this.getType().newValue();
        clone.assignFrom(this);
        return clone;
    }

    public static int compareValue(IValue left, IValue right) {
        int c = ValueBase.compareStatus(left.getStatus(), right.getStatus());
        if (c != 0) {
            return c;
        }
        IDataType commonType = DataTypes.widestCompatibleType(left.getType(), right.getType());
        IValue coercedLeft = commonType.newValue();
        IValue coercedRight = commonType.newValue();
        coercedLeft.assignFrom(left);
        coercedRight.assignFrom(right);
        return coercedLeft.compareTo(coercedRight);
    }

    protected static int compareStatus(ValueStatus left, ValueStatus right) {
        int rightOrd;
        int leftOrd = left.ordinal();
        if (leftOrd == (rightOrd = right.ordinal())) {
            return 0;
        }
        if (leftOrd < rightOrd) {
            return -1;
        }
        return 1;
    }

    @Override
    public void setFormatProperties(FormatProperties formatProperties) {
        this.mFormatProperties = formatProperties;
    }

    @Override
    public FormatProperties getFormatProperties() {
        return this.mFormatProperties;
    }
}

