/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.model.value.decor;

import com.ibm.cognos.aurora.api.model.value.decor.EDecorationType;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.api.util.EncoderContext;
import com.ibm.cognos.aurora.core.io.EncodeUtil;
import com.ibm.icu.util.Currency;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.dom4j.Element;

public final class CurrencyDecoration
implements IValueDecoration {
    private Currency mCurrency;

    public CurrencyDecoration(Currency currency) {
        if (null == currency) {
            throw new NullPointerException("currency was null");
        }
        this.mCurrency = currency;
    }

    CurrencyDecoration() {
    }

    @Override
    public EDecorationType getType() {
        return EDecorationType.CURRENCY;
    }

    @Override
    public boolean isPercent() {
        return false;
    }

    @Override
    public boolean isCurrency() {
        return true;
    }

    @Override
    public boolean isThousandsSeparator() {
        return false;
    }

    public Currency getCurrency() {
        return this.mCurrency;
    }

    @Override
    public void encodeElement(Element elem, EncoderContext ctx) {
        elem.addAttribute("currencyCode", this.mCurrency.getCurrencyCode());
    }

    @Override
    public void decodeElement(Element elem, EncoderContext ctx) {
        this.mCurrency = Currency.getInstance((String)elem.attributeValue("currencyCode"));
    }

    @Override
    public void encodeBinary(DataOutput out, EncoderContext ctx) throws IOException {
        EncodeUtil.writeString(out, this.mCurrency.getCurrencyCode());
    }

    @Override
    public void decodeBinary(DataInput in, EncoderContext ctx) throws IOException {
        this.mCurrency = Currency.getInstance((String)EncodeUtil.readString(in));
    }

    public String toString() {
        return String.format("CurrencyDecoration(%s)", this.mCurrency.getCurrencyCode());
    }

    public int hashCode() {
        return this.getType().hashCode() + this.mCurrency.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CurrencyDecoration)) {
            return false;
        }
        CurrencyDecoration other = (CurrencyDecoration)o;
        return this.mCurrency.equals((Object)other.mCurrency);
    }
}

