/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.query;

import com.ibm.cognos.aurora.api.query.EQLSMessageCode;
import com.ibm.neo.exception.WatsonException;
import com.ibm.neo.exception.WatsonMessageContext;
import java.sql.SQLException;

public class QLSQueryException
extends WatsonException {
    private static final long serialVersionUID = 1L;

    public QLSQueryException() {
        super("Internal error", null, EQLSMessageCode.createMessageContext(EQLSMessageCode.INTERNAL_ERROR));
    }

    public QLSQueryException(String _message) {
        super(_message, null, EQLSMessageCode.createMessageContext(EQLSMessageCode.INTERNAL_ERROR));
    }

    public QLSQueryException(Throwable _cause) {
        super("Internal error", _cause, EQLSMessageCode.createMessageContext(EQLSMessageCode.INTERNAL_ERROR));
    }

    public QLSQueryException(String _message, Throwable _cause) {
        super(_message, _cause, EQLSMessageCode.createMessageContext(EQLSMessageCode.INTERNAL_ERROR));
    }

    public QLSQueryException(String _message, Throwable _cause, WatsonMessageContext _messageContext) {
        super(_message, _cause, _messageContext);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String mMessage = null;
        private Throwable mCause = null;
        private EQLSMessageCode mCoditionCode = EQLSMessageCode.INTERNAL_ERROR;

        public Builder withMessage(String message) {
            this.mMessage = message;
            return this;
        }

        public Builder withCause(Throwable cause) {
            this.mCause = cause;
            return this;
        }

        public Builder withConditionCode(EQLSMessageCode conditionCode) {
            this.mCoditionCode = conditionCode;
            return this;
        }

        public QLSQueryException build() {
            WatsonMessageContext context = new WatsonMessageContext((Enum)this.mCoditionCode);
            return new QLSQueryException(this.mMessage, this.mCause, context);
        }
    }

    public static class ValidationException
    extends QLSQueryException {
        private static final long serialVersionUID = 1L;

        public ValidationException(Throwable _cause) {
            super(null, _cause, EQLSMessageCode.createMessageContext(EQLSMessageCode.VALIDATION_ERROR));
        }
    }

    public static class TimeoutException
    extends QLSQueryException {
        private static final long serialVersionUID = 1L;

        public TimeoutException() {
            super(null, null, EQLSMessageCode.createMessageContext(EQLSMessageCode.MAXIMUM_RESULT_SIZE));
        }
    }

    public static class ResourceExhaustion
    extends QLSQueryException {
        private static final long serialVersionUID = 1L;

        public ResourceExhaustion(SQLException cause) {
            super("Insufficient database resources to continue. Please try again later.", cause, EQLSMessageCode.createMessageContext(EQLSMessageCode.DATABASE_RESOURCES_EXHAUSTED));
        }
    }

    public static class MaximumResultSizeException
    extends QLSQueryException {
        private static final long serialVersionUID = 1L;

        public MaximumResultSizeException(Throwable _cause) {
            super(null, _cause, EQLSMessageCode.createMessageContext(EQLSMessageCode.MAXIMUM_RESULT_SIZE));
        }
    }

    public static class JDBCException
    extends QLSQueryException {
        private static final long serialVersionUID = 1L;

        public JDBCException(String message, SQLException cause) {
            super(message, cause, EQLSMessageCode.createMessageContext(EQLSMessageCode.JDBC_ERROR));
        }
    }

    public static class ConnectionFailure
    extends QLSQueryException {
        private static final long serialVersionUID = 1L;

        public ConnectionFailure(String message, Throwable cause) {
            super(message, cause, EQLSMessageCode.createMessageContext(EQLSMessageCode.CONNECTION_FAILURE));
        }
    }
}

