/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.query.queryspec.util;

import com.ibm.cognos.aurora.api.model.IMember;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.queryspec.QuerySpecNodeFactory;
import com.ibm.cognos.aurora.api.query.queryspec.expression.EOperator;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ILiteralNode;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IMemberReference;
import com.ibm.cognos.aurora.api.query.queryspec.expression.IOperator;
import com.ibm.cognos.aurora.api.query.queryspec.expression.ITuple;

public abstract class FilterDetailValuesHelper {
    private FilterDetailValuesHelper() {
    }

    public static IOperator createConditionWithRange(IMember[] members, IValue start, IValue end, QuerySpecNodeFactory nodeFactory) {
        if (members == null || members.length == 0) {
            throw new IllegalArgumentException("Must specify one or more members");
        }
        ITuple tuple = nodeFactory.createTuple();
        for (IMember member : members) {
            IMemberReference memberRef = nodeFactory.createMemberReference(member);
            tuple.addParameter(memberRef);
        }
        if (start.isNull() && end.isNull()) {
            throw new IllegalStateException("Unsupported range with both start and end that are null.");
        }
        if (start.isNull()) {
            return FilterDetailValuesHelper.createBinaryOperator(EOperator.LESS_THAN_OR_EQUAL, tuple, FilterDetailValuesHelper.createLiteral(end, nodeFactory), nodeFactory);
        }
        if (end.isNull()) {
            return FilterDetailValuesHelper.createBinaryOperator(EOperator.GREATER_THAN_OR_EQUAL, tuple, FilterDetailValuesHelper.createLiteral(start, nodeFactory), nodeFactory);
        }
        return FilterDetailValuesHelper.createTrinaryOperator(EOperator.BETWEEN, tuple, FilterDetailValuesHelper.createLiteral(start, nodeFactory), FilterDetailValuesHelper.createLiteral(end, nodeFactory), nodeFactory);
    }

    public static IOperator combineConditions(EOperator booleanOperator, IOperator condition1, IOperator condition2, QuerySpecNodeFactory nodeFactory) {
        if (booleanOperator != EOperator.AND && booleanOperator != EOperator.OR) {
            throw new IllegalStateException("Unsupported booleanOperator type: " + booleanOperator.toString());
        }
        IOperator condition = nodeFactory.createOperatorNode(booleanOperator);
        condition.addParameter(condition1);
        condition.addParameter(condition2);
        return condition;
    }

    public static IOperator negateCondition(IOperator condition, QuerySpecNodeFactory nodeFactory) {
        IOperator notCondition = nodeFactory.createOperatorNode(EOperator.NOT);
        condition.addParameter(condition);
        return notCondition;
    }

    private static IOperator createBinaryOperator(EOperator operatorType, ITuple tuple, ILiteralNode literal, QuerySpecNodeFactory nodeFactory) {
        IOperator operator = nodeFactory.createOperatorNode(operatorType);
        operator.addParameter(tuple);
        operator.addParameter(literal);
        return operator;
    }

    private static IOperator createTrinaryOperator(EOperator operatorType, ITuple tuple, ILiteralNode literal1, ILiteralNode literal2, QuerySpecNodeFactory nodeFactory) {
        IOperator operator = nodeFactory.createOperatorNode(operatorType);
        operator.addParameter(tuple);
        operator.addParameter(literal1);
        operator.addParameter(literal2);
        return operator;
    }

    private static ILiteralNode createLiteral(IValue value, QuerySpecNodeFactory nodeFactory) {
        return nodeFactory.createLiteralNode(value);
    }
}

