/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.smd;

import com.ibm.cognos.aurora.api.model.IDataItem;
import com.ibm.cognos.aurora.api.model.ISampleDataProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.collections.map.MultiValueMap;

public class SmdReqContext {
    private EScope mScope;
    private Map<EOption, Object> mOptions = new HashMap<EOption, Object>();
    private MultiMap mDataItemInfo = new MultiValueMap();
    private ISampleDataProvider mSampleProvider;

    public SmdReqContext(EScope s) {
        this.mScope = s;
    }

    protected SmdReqContext(SmdReqContext context) {
        this(context.getScope());
        Map<EOption, Object> map = context.getOptions();
        Set<Map.Entry<EOption, Object>> entryset = map.entrySet();
        if (entryset != null) {
            for (Map.Entry<EOption, Object> entry : entryset) {
                this.addAnalysisOption(entry.getKey(), entry.getValue());
            }
        }
        for (EDataItemInfo key : EDataItemInfo.values()) {
            Collection<List<IDataItem>> obj = context.getDataItemsFor(key);
            if (obj == null) continue;
            for (List<IDataItem> list : obj) {
                this.addDataItemInfo(key, list);
            }
        }
        this.setSampleProvider(context.getSampleProvider());
    }

    public EScope getScope() {
        return this.mScope;
    }

    public void addAnalysisOption(EOption key, Object value) {
        this.mOptions.put(key, value);
    }

    public Object getOption(EOption key) {
        return this.mOptions.get((Object)key);
    }

    public boolean containsKey(EOption key) {
        return this.mOptions.containsKey((Object)key);
    }

    public Map<EOption, Object> getOptions() {
        return this.mOptions;
    }

    public void addDataItemInfo(EDataItemInfo infoKey, List<IDataItem> applicableDIs) {
        this.mDataItemInfo.put((Object)infoKey, applicableDIs);
    }

    public Collection<List<IDataItem>> getDataItemsFor(EDataItemInfo infoKey) {
        return (Collection)this.mDataItemInfo.get((Object)infoKey);
    }

    public ISampleDataProvider getSampleProvider() {
        return this.mSampleProvider;
    }

    public void setSampleProvider(ISampleDataProvider sampleProvider) {
        this.mSampleProvider = sampleProvider;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SmdReqContext[scope=").append((Object)this.mScope).append(", dataItemInfo=").append(this.mDataItemInfo).append(", options=").append(this.mOptions).append("]");
        return sb.toString();
    }

    public static enum EDataItemInfo {
        eKnownMetric,
        eKnownCategory,
        eKnownGroup,
        eKnownWholePart,
        eKnownStorageKey,
        eKnownStorageIndex;

    }

    public static enum EOption {
        eContentLocaleName,
        eContentLocale,
        eDisableDataDrivenAnalyses,
        eExamineCaptionUniqueness,
        eModelCache;

    }

    public static enum EScope {
        eBuildModel,
        eDecorateModel,
        eBuildHierarchicalCategories;

    }
}

