/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.api.util;

import com.ibm.cognos.aurora.api.util.IJSONSerializable;
import com.ibm.json.java.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class ResponseStatus
implements IJSONSerializable {
    public static final String ENCODING = "UTF-8";
    public static final String CODE = "code";
    public static final String MESSAGE = "message";
    public static final String LEVEL = "level";
    public static final String DESCRIPTION = "description";
    public static final String MORE_INFO = "moreInfo";
    public static final String DEVELOPER = "developer";
    private String code;
    private String message;
    private Level level;
    private String description;
    private URL moreInfo;
    private String developer;

    public ResponseStatus() {
        this("", "", null, "", null, "");
    }

    public ResponseStatus(String code, String message, Level level, String description, URL moreInfo, String developer) {
        this.setCode(code);
        this.setMessage(message);
        this.setLevel(level);
        this.setDescription(description);
        this.setMoreInfo(moreInfo);
        this.setDeveloper(developer);
    }

    @Override
    public JSONObject toJSON() throws Exception {
        JSONObject obj = new JSONObject();
        obj.put((Object)CODE, (Object)this.getCode());
        obj.put((Object)MESSAGE, (Object)this.getMessage());
        if (this.getLevel() != null) {
            obj.put((Object)LEVEL, (Object)this.getLevel().name());
        } else {
            obj.put((Object)LEVEL, (Object)Level.OK.name());
        }
        obj.put((Object)DESCRIPTION, (Object)this.getDescription());
        obj.put((Object)MORE_INFO, (Object)this.getMoreInfoAsString());
        obj.put((Object)DEVELOPER, (Object)this.getDeveloper());
        return obj;
    }

    private String getMoreInfoAsString() {
        if (this.moreInfo != null) {
            try {
                return URLEncoder.encode(this.moreInfo.toString(), ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public void fromJSON(JSONObject json) throws Exception {
        if (json != null) {
            Object developer;
            Object moreInfo;
            Object description;
            Object level;
            Object message;
            Object code;
            if (json.containsKey((Object)CODE) && (code = json.get((Object)"CODE")) instanceof String) {
                this.setCode((String)code);
            }
            if (json.containsKey((Object)MESSAGE) && (message = json.get((Object)MESSAGE)) instanceof String) {
                this.setMessage((String)message);
            }
            if (json.containsKey((Object)LEVEL) && (level = json.get((Object)LEVEL)) instanceof String) {
                this.setLevel(this.getLevelFromString((String)level));
            }
            if (json.containsKey((Object)DESCRIPTION) && (description = json.get((Object)DESCRIPTION)) instanceof String) {
                this.setDescription((String)description);
            }
            if (json.containsKey((Object)MORE_INFO) && (moreInfo = json.get((Object)MORE_INFO)) instanceof String) {
                String decoded = URLDecoder.decode((String)moreInfo, ENCODING);
                URL url = new URL(decoded);
                this.setMoreInfo(url);
            }
            if (json.containsKey((Object)DEVELOPER) && (developer = json.get((Object)DEVELOPER)) instanceof String) {
                this.setDeveloper((String)developer);
            }
        }
    }

    private Level getLevelFromString(String level) {
        if ("OK".equals(level)) {
            return Level.OK;
        }
        if ("WARNING".equals(level)) {
            return Level.WARNING;
        }
        if ("ERROR".equals(level)) {
            return Level.ERROR;
        }
        return null;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public URL getMoreInfo() {
        return this.moreInfo;
    }

    public void setMoreInfo(URL moreInfo) {
        this.moreInfo = moreInfo;
    }

    public String getDeveloper() {
        return this.developer;
    }

    public void setDeveloper(String developer) {
        this.developer = developer;
    }

    public static enum Level {
        OK,
        WARNING,
        ERROR;

    }
}

