/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.data.IValueTupleIterator;
import com.ibm.cognos.aurora.core.bvt.IBVTableReader;
import java.io.IOException;
import java.util.NoSuchElementException;

public class BVTableIteratorAdapter
implements IValueTupleIterator {
    private final IBVTableReader mReader;
    private final long mNumRows;
    private long mNextRow;

    public BVTableIteratorAdapter(IBVTableReader reader, long numRows) {
        this.mReader = reader;
        this.mNumRows = numRows;
        this.mNextRow = 0L;
    }

    @Override
    public boolean hasNext() {
        return this.mNextRow < this.mNumRows;
    }

    @Override
    public IValue[] next() {
        if (this.mNextRow >= this.mNumRows) {
            throw new NoSuchElementException();
        }
        try {
            ++this.mNextRow;
            return this.mReader.nextRow();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void reset() {
        this.mNextRow = 0L;
        try {
            this.mReader.reset();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.mReader.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

