/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.disk;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.core.bvt.IBVColumn;
import com.ibm.cognos.aurora.core.bvt.disk.DiskBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.disk.DiskBVColumnReader;
import com.ibm.cognos.aurora.core.bvt.disk.DiskIndexAppender;
import com.ibm.cognos.aurora.core.bvt.disk.DiskIndexReader;
import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.commons.io.FileUtils;

public class DiskBVColumn
implements IBVColumn {
    private final File mDataFile;
    private final File mIndexFile;
    private final boolean mRandomAccess;
    private long mRecordCount = 0L;

    public DiskBVColumn(String dataFilePath, boolean isRandomAccess) {
        this.mRandomAccess = isRandomAccess;
        this.mDataFile = new File(dataFilePath);
        this.mIndexFile = this.mRandomAccess ? new File(dataFilePath + ".index") : null;
    }

    @Override
    public boolean isRandomAccess() {
        return this.mRandomAccess;
    }

    public File getDataFile() {
        return this.mDataFile;
    }

    public File getIndexFile() {
        return this.mIndexFile;
    }

    @Override
    public long getRecordCount() {
        return this.mRecordCount;
    }

    public void setRecordCount(long recordCount) {
        this.mRecordCount = recordCount;
    }

    public void incrementRecordCount() {
        ++this.mRecordCount;
    }

    @Override
    public DiskBVColumnAppender openAppender() throws IOException {
        FileUtils.forceMkdir((File)this.mDataFile.getParentFile());
        if (this.isRandomAccess()) {
            DiskIndexAppender index = new DiskIndexAppender(this.mIndexFile);
            try {
                return new DiskBVColumnAppender(this, index, this.mDataFile);
            }
            catch (IOException ex) {
                index.close();
                throw ex;
            }
        }
        return new DiskBVColumnAppender(this, null, this.mDataFile);
    }

    @Override
    public DiskBVColumnReader openReader() throws IOException {
        if (this.isRandomAccess()) {
            DiskIndexReader indexReader = new DiskIndexReader(this.mIndexFile);
            try {
                return new DiskBVColumnReader(this, indexReader, this.mDataFile);
            }
            catch (IOException ex) {
                indexReader.close();
                throw ex;
            }
        }
        return new DiskBVColumnReader(this, null, this.mDataFile);
    }

    @Override
    public IValueIterator openIterator() throws IOException {
        return new Iter(this.openReader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFrom(IBVColumn source) throws IOException {
        if (source instanceof DiskBVColumn) {
            DiskBVColumn sourceDiskColumn = (DiskBVColumn)source;
            if (this.isRandomAccess() && sourceDiskColumn.isRandomAccess()) {
                FileUtils.copyFile((File)sourceDiskColumn.getIndexFile(), (File)this.getIndexFile(), (boolean)false);
            }
            FileUtils.copyFile((File)sourceDiskColumn.getDataFile(), (File)this.getDataFile(), (boolean)false);
            this.setRecordCount(source.getRecordCount());
        } else {
            if (this.getIndexFile().exists()) {
                FileUtils.forceDelete((File)this.getIndexFile());
            }
            if (this.getDataFile().exists()) {
                FileUtils.forceDelete((File)this.getDataFile());
            }
            DiskBVColumnAppender appender = this.openAppender();
            try {
                IValueIterator iter = source.openIterator();
                try {
                    while (iter.hasNext()) {
                        appender.append(iter.next());
                    }
                }
                finally {
                    iter.close();
                }
            }
            finally {
                appender.close();
            }
        }
    }

    @Override
    public void clear() throws IOException {
        this.setRecordCount(0L);
        if (this.isRandomAccess() && this.getIndexFile().exists()) {
            FileUtils.forceDelete((File)this.getIndexFile());
        }
        if (this.getDataFile().exists()) {
            FileUtils.forceDelete((File)this.getDataFile());
        }
    }

    @Override
    public void dispose() {
        this.setRecordCount(0L);
        if (this.getDataFile().exists() && !this.getDataFile().delete()) {
            this.getDataFile().deleteOnExit();
        }
        if (this.isRandomAccess() && this.getIndexFile().exists() && !this.getIndexFile().delete()) {
            this.getIndexFile().deleteOnExit();
        }
    }

    private final class Iter
    implements IValueIterator {
        private final DiskBVColumnReader mReader;
        private long mNextIndex = 0L;

        Iter(DiskBVColumnReader reader) {
            this.mReader = reader;
        }

        @Override
        public boolean hasNext() {
            return this.mNextIndex < DiskBVColumn.this.mRecordCount;
        }

        @Override
        public IValue next() {
            if (this.mNextIndex >= DiskBVColumn.this.mRecordCount) {
                throw new NoSuchElementException();
            }
            try {
                IValue v = this.mReader.next();
                ++this.mNextIndex;
                return v;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void reset() {
            this.mNextIndex = 0L;
            try {
                this.mReader.reset();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void close() {
            try {
                this.mReader.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

