/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.disk;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.core.bvt.IBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.disk.DiskBVColumn;
import com.ibm.cognos.aurora.core.bvt.disk.DiskIndexAppender;
import com.ibm.cognos.aurora.core.io.FileChannelDataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class DiskBVColumnAppender
implements IBVColumnAppender {
    private final DiskBVColumn mColumn;
    private final DiskIndexAppender mIndex;
    private final FileChannelDataOutputStream mDataOutput;

    public DiskBVColumnAppender(DiskBVColumn column, DiskIndexAppender index, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, true);
        this.mColumn = column;
        this.mIndex = index;
        this.mDataOutput = new FileChannelDataOutputStream(fos.getChannel());
    }

    @Override
    public void append(IValue value) throws IOException {
        long pos = this.mDataOutput.position();
        try {
            if (null == value) {
                ValueFactory.encodeBinary(this.mDataOutput, null, ValueFactory.createString(null));
            } else {
                ValueFactory.encodeBinary(this.mDataOutput, null, value);
            }
            if (this.mColumn.isRandomAccess()) {
                this.mIndex.append(pos);
            }
            this.mColumn.incrementRecordCount();
        }
        catch (IOException ex) {
            this.mDataOutput.position(pos);
            throw ex;
        }
        catch (RuntimeException ex) {
            this.mDataOutput.position(pos);
            throw ex;
        }
    }

    @Override
    public void flush() throws IOException {
        this.mDataOutput.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.mColumn.isRandomAccess()) {
                this.mIndex.close();
            }
        }
        finally {
            this.mDataOutput.close();
        }
    }
}

