/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.heap;

import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.core.bvt.IBVColumn;
import com.ibm.cognos.aurora.core.bvt.heap.HeapBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.heap.HeapBVColumnReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class HeapBVColumn
implements IBVColumn {
    private final List<IValue> mElements = new ArrayList<IValue>();

    @Override
    public boolean isRandomAccess() {
        return true;
    }

    @Override
    public long getRecordCount() {
        return this.mElements.size();
    }

    @Override
    public HeapBVColumnAppender openAppender() throws IOException {
        return new HeapBVColumnAppender(this.mElements);
    }

    @Override
    public HeapBVColumnReader openReader() throws IOException {
        return new HeapBVColumnReader(this.mElements);
    }

    @Override
    public IValueIterator openIterator() throws IOException {
        return new Iter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyFrom(IBVColumn source) throws IOException {
        this.mElements.clear();
        if (source instanceof HeapBVColumn) {
            this.mElements.addAll(((HeapBVColumn)source).mElements);
        } else {
            IValueIterator iter = source.openIterator();
            try {
                while (iter.hasNext()) {
                    this.mElements.add(iter.next());
                }
            }
            finally {
                iter.close();
            }
        }
    }

    @Override
    public void clear() throws IOException {
        this.mElements.clear();
    }

    @Override
    public void dispose() {
        this.mElements.clear();
    }

    private final class Iter
    implements IValueIterator {
        private Iterator<IValue> mSource;

        Iter() {
            this.mSource = HeapBVColumn.this.mElements.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.mSource.hasNext();
        }

        @Override
        public IValue next() {
            return this.mSource.next();
        }

        @Override
        public void reset() {
            this.mSource = HeapBVColumn.this.mElements.iterator();
        }

        @Override
        public void close() {
        }
    }
}

