/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.bvt.hybrid;

import com.ibm.cognos.aurora.api.query.data.IValueTupleIterator;
import com.ibm.cognos.aurora.core.bvt.BVTableIteratorAdapter;
import com.ibm.cognos.aurora.core.bvt.DefaultBVTableAppender;
import com.ibm.cognos.aurora.core.bvt.DefaultBVTableReader;
import com.ibm.cognos.aurora.core.bvt.IBVColumn;
import com.ibm.cognos.aurora.core.bvt.IBVColumnAppender;
import com.ibm.cognos.aurora.core.bvt.IBVColumnReader;
import com.ibm.cognos.aurora.core.bvt.IBVTable;
import com.ibm.cognos.aurora.core.bvt.IBVTableAppender;
import com.ibm.cognos.aurora.core.bvt.IBVTableReader;
import com.ibm.cognos.aurora.core.bvt.disk.DiskBVTable;
import com.ibm.cognos.aurora.core.bvt.heap.HeapBVTable;
import com.ibm.cognos.aurora.core.bvt.hybrid.HybridBVColumn;
import com.ibm.cognos.aurora.core.bvt.hybrid.HybridBVTableAppender;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class HybridBVTable
implements IBVTable {
    private final ArrayList<HybridBVColumn> mColumns = new ArrayList();
    private HeapBVTable mHeapTable = new HeapBVTable();
    private DiskBVTable mDiskTable;
    private boolean mSpilledOver = false;

    public HybridBVTable(String dataDirPath) {
        this.mDiskTable = new DiskBVTable(dataDirPath);
    }

    public HybridBVTable(String dataDirPath, boolean isRandomAccess) {
        this.mDiskTable = new DiskBVTable(dataDirPath, isRandomAccess);
    }

    @Override
    public boolean isRandomAccess() {
        return this.mDiskTable.isRandomAccess();
    }

    boolean isSpilledOver() {
        return this.mSpilledOver;
    }

    void spillOver() throws IOException {
        this.mSpilledOver = true;
        this.mHeapTable.dispose();
        this.mHeapTable = null;
        for (HybridBVColumn col : this.mColumns) {
            col.spillOver();
        }
    }

    @Override
    public long numRows() {
        if (this.mColumns.isEmpty()) {
            return 0L;
        }
        return this.mColumns.get(0).getRecordCount();
    }

    @Override
    public int numColumns() {
        return this.mColumns.size();
    }

    @Override
    public IBVColumn[] getColumns() {
        return this.mColumns.toArray(new IBVColumn[0]);
    }

    @Override
    public HybridBVColumn getColumn(int index) {
        return this.mColumns.get(index);
    }

    @Override
    public int indexOf(IBVColumn col) {
        for (int i = 0; i < this.mColumns.size(); ++i) {
            if (!this.mColumns.get(i).equals(col)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public HybridBVColumn newColumn() {
        HybridBVColumn col = this.isSpilledOver() ? new HybridBVColumn(this, null, this.mDiskTable.newColumn()) : new HybridBVColumn(this, this.mHeapTable.newColumn(), this.mDiskTable.newColumn());
        this.mColumns.add(col);
        return col;
    }

    @Override
    public void dropColumn(int index) {
        HybridBVColumn col = this.mColumns.remove(index);
        col.dispose();
        if (this.isSpilledOver()) {
            this.mDiskTable.dropColumn(index);
        } else {
            this.mHeapTable.dropColumn(index);
        }
    }

    @Override
    public void dropColumn(IBVColumn col) {
        HybridBVColumn hybridCol = (HybridBVColumn)col;
        Iterator<HybridBVColumn> colIter = this.mColumns.iterator();
        while (colIter.hasNext()) {
            if (colIter.next() != hybridCol) continue;
            colIter.remove();
            if (this.isSpilledOver()) {
                this.mDiskTable.dropColumn(hybridCol.mDiskColumn);
            } else {
                this.mHeapTable.dropColumn(hybridCol.mHeapColumn);
            }
            hybridCol.dispose();
            return;
        }
        throw new RuntimeException("Column not in table: " + String.valueOf(col));
    }

    @Override
    public IBVTableAppender openAppender() throws IOException {
        IBVColumnAppender[] appenders = new IBVColumnAppender[this.mColumns.size()];
        try {
            for (int i = 0; i < this.mColumns.size(); ++i) {
                appenders[i] = this.mColumns.get(i).openAppender();
            }
        }
        catch (Exception ex) {
            for (int i = 0; i < this.mColumns.size(); ++i) {
                if (null == appenders[i]) continue;
                appenders[i].close();
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw (RuntimeException)ex;
        }
        if (this.isSpilledOver()) {
            return new DefaultBVTableAppender(appenders);
        }
        return new HybridBVTableAppender(this, appenders);
    }

    @Override
    public IBVTableReader openReader() throws IOException {
        IBVColumnReader[] readers = new IBVColumnReader[this.mColumns.size()];
        try {
            for (int i = 0; i < this.mColumns.size(); ++i) {
                readers[i] = this.mColumns.get(i).openReader();
            }
        }
        catch (Exception ex) {
            for (int i = 0; i < this.mColumns.size(); ++i) {
                if (null == readers[i]) continue;
                readers[i].close();
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw (RuntimeException)ex;
        }
        return new DefaultBVTableReader(readers);
    }

    @Override
    public IValueTupleIterator openIterator() throws IOException {
        return new BVTableIteratorAdapter(this.openReader(), this.numRows());
    }

    @Override
    public void clear() throws IOException {
        for (HybridBVColumn c : this.mColumns) {
            c.clear();
        }
    }

    @Override
    public void dispose() {
        for (HybridBVColumn c : this.mColumns) {
            c.dispose();
        }
        this.mColumns.clear();
        if (null != this.mHeapTable) {
            this.mHeapTable.dispose();
            this.mHeapTable = null;
        }
        if (null != this.mDiskTable) {
            this.mDiskTable.dispose();
            this.mDiskTable = null;
        }
    }
}

