/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.expert.trace;

import com.ibm.cognos.aurora.core.util.IDGenerator;
import com.ibm.cognos.aurora.core.util.StringSubstitutionEngine;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Stack;

public class XMLWriter {
    private static final String XML_ELEMENT_CLOSING = ">";
    private static final String XML_LINE_FEED = "\n";
    private static final String XML_DOUBLE_QUOTES = "\"";
    public static final int NO_OBJECT_IDENTIFIER = -1;
    public static final int UNSPECIFIED_PRECISION = -1;
    protected Stack<XMLElement> mObjectStack = new Stack();
    protected ArrayList<Writer> mStreamWriters;
    protected String mIndentString;
    private int roundDoubleDecimalPlaces = -1;
    protected IDGenerator mIdGenerator;
    private boolean skipLineFeed = false;

    public XMLWriter() {
        this.mObjectStack.empty();
        this.mStreamWriters = new ArrayList();
        this.mStreamWriters.clear();
    }

    public void addStream(Writer streamWriter) {
        this.mStreamWriters.add(streamWriter);
    }

    public void removeStream(Writer streamWriter) {
        this.mStreamWriters.remove(streamWriter);
    }

    public void beginElement(String name) {
        this.beginElement(name, -1);
    }

    public void beginElement(String name, Integer id) {
        this.beginElement(name, (int)id);
    }

    public void beginElement(String name, int id) {
        boolean deferredDeclarationCompleted = false;
        try {
            ListIterator<Writer> streamIterator = this.mStreamWriters.listIterator();
            while (streamIterator.hasNext()) {
                Writer writer = streamIterator.next();
                if (this.mObjectStack.size() > 0 && !this.mObjectStack.peek().getDeclarationCompleted()) {
                    writer.write(XML_ELEMENT_CLOSING);
                    if (!this.skipLineFeed()) {
                        writer.write(XML_LINE_FEED);
                    }
                    deferredDeclarationCompleted = true;
                }
                this.indent(writer);
                writer.write("<");
                writer.write(name);
                if (id == -1) continue;
                writer.write(" id=\"");
                writer.write(String.valueOf(id));
                writer.write(XML_DOUBLE_QUOTES);
            }
            if (deferredDeclarationCompleted) {
                this.mObjectStack.peek().setDeclarationCompleted(true);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        XMLElement element = new XMLElement(name);
        this.mObjectStack.push(element);
    }

    public void writeXML(String xml) {
        ListIterator<Writer> streamIterator = this.mStreamWriters.listIterator();
        while (streamIterator.hasNext()) {
            Writer writer = streamIterator.next();
            try {
                writer.write(xml);
            }
            catch (Exception e) {}
        }
    }

    public void endElement() {
        try {
            XMLElement element = this.mObjectStack.pop();
            ListIterator<Writer> streamIterator = this.mStreamWriters.listIterator();
            while (streamIterator.hasNext()) {
                Writer writer = streamIterator.next();
                boolean needEndingStatement = true;
                if (!element.getDeclarationCompleted()) {
                    writer.write("/>\n");
                    needEndingStatement = false;
                }
                if (!needEndingStatement) continue;
                if (!element.hasData) {
                    this.indent(writer);
                }
                writer.write("</");
                writer.write(element.getName());
                writer.write(XML_ELEMENT_CLOSING);
                writer.write(XML_LINE_FEED);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void data(String data) {
        boolean deferredDeclarationCompleted = false;
        try {
            XMLElement element = this.mObjectStack.peek();
            ListIterator<Writer> streamIterator = this.mStreamWriters.listIterator();
            while (streamIterator.hasNext()) {
                Writer writer = streamIterator.next();
                if (!element.getDeclarationCompleted()) {
                    writer.write(XML_ELEMENT_CLOSING);
                    deferredDeclarationCompleted = true;
                }
                writer.write(StringSubstitutionEngine.escapeStringForXML(data));
                element.setHasData(true);
            }
            element.setDeclarationCompleted(deferredDeclarationCompleted);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void cdata(String data) {
        boolean deferredDeclarationCompleted = false;
        try {
            XMLElement element = this.mObjectStack.peek();
            ListIterator<Writer> streamIterator = this.mStreamWriters.listIterator();
            while (streamIterator.hasNext()) {
                Writer writer = streamIterator.next();
                if (!element.getDeclarationCompleted()) {
                    writer.write(XML_ELEMENT_CLOSING);
                    deferredDeclarationCompleted = true;
                }
                writer.write("<![CDATA[");
                writer.write(data);
                writer.write("]]>");
                element.setHasData(true);
            }
            element.setDeclarationCompleted(deferredDeclarationCompleted);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void xml(String data) {
        boolean deferredDeclarationCompleted = false;
        try {
            ListIterator<Writer> streamIterator = this.mStreamWriters.listIterator();
            while (streamIterator.hasNext()) {
                Writer writer = streamIterator.next();
                if (this.mObjectStack.size() > 0 && !this.mObjectStack.peek().getDeclarationCompleted()) {
                    writer.write(XML_ELEMENT_CLOSING);
                    if (!this.skipLineFeed()) {
                        writer.write(XML_LINE_FEED);
                    }
                    deferredDeclarationCompleted = true;
                }
                this.indent(writer);
                writer.write(data);
            }
            if (deferredDeclarationCompleted) {
                this.mObjectStack.peek().setDeclarationCompleted(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeHeader(String version, String encoding) {
        try {
            ListIterator<Writer> streamIterator = this.mStreamWriters.listIterator();
            while (streamIterator.hasNext()) {
                Writer writer = streamIterator.next();
                writer.write("<?xml version=\"" + version + "\" encoding=\"" + encoding + "\"?>");
                if (this.skipLineFeed()) continue;
                writer.write(XML_LINE_FEED);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeProcessingInstruction(String value) {
        try {
            ListIterator<Writer> streamIterator = this.mStreamWriters.listIterator();
            while (streamIterator.hasNext()) {
                Writer writer = streamIterator.next();
                writer.write(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeProperty(String name, String value) {
        XMLElement element = this.mObjectStack.peek();
        try {
            ListIterator<Writer> streamIterator = this.mStreamWriters.listIterator();
            while (streamIterator.hasNext()) {
                Writer writer = streamIterator.next();
                if (!element.getDeclarationCompleted()) {
                    writer.write(XML_ELEMENT_CLOSING);
                    writer.write(XML_LINE_FEED);
                }
                writer.write("<property name=\"");
                writer.write(name);
                writer.write("\" value=\"");
                writer.write(value);
                writer.write("\"/>");
                writer.write(XML_LINE_FEED);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        element.setDeclarationCompleted(true);
    }

    public void property(String name, String value) {
        this.writeProperty(name, StringSubstitutionEngine.escapeStringForXML(value));
    }

    public void property(String name, int value) {
        this.writeProperty(name, String.valueOf(value));
    }

    public void property(String name, float value) {
        this.writeProperty(name, String.valueOf(value));
    }

    public void property(String name, double value) {
        this.writeProperty(name, String.valueOf(value));
    }

    public void property(String name, boolean value) {
        this.writeProperty(name, String.valueOf(value));
    }

    public void writeAttribute(String name, String value) {
        try {
            ListIterator<Writer> streamIterator = this.mStreamWriters.listIterator();
            while (streamIterator.hasNext()) {
                Writer writer = streamIterator.next();
                writer.write(" ");
                writer.write(name);
                writer.write("=\"");
                writer.write(value);
                writer.write(XML_DOUBLE_QUOTES);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void attribute(String name, String value) {
        this.writeAttribute(name, StringSubstitutionEngine.escapeStringForXML(value));
    }

    public void attribute(String name, int value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void attribute(String name, long value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void attribute(String name, float value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void attribute(String name, double value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void attribute(String name, boolean value) {
        this.writeAttribute(name, String.valueOf(value));
    }

    public void attribute(String name, Object value) {
        this.writeAttribute(name, StringSubstitutionEngine.escapeStringForXML(value.toString()));
    }

    public int getRoundDoubleDecimalPlaces() {
        return this.roundDoubleDecimalPlaces;
    }

    public void setRoundDoubleDecimalPlaces(int numDecimalPlaces) {
        this.roundDoubleDecimalPlaces = numDecimalPlaces;
    }

    public boolean isEmpty() {
        return this.mObjectStack.isEmpty();
    }

    public void setNodeIDGenerator(IDGenerator idGenerator) {
        this.mIdGenerator = idGenerator;
    }

    public int getNodeID() {
        return this.mIdGenerator.getNextID();
    }

    public String getIndentString() {
        return this.mIndentString;
    }

    public void setIndentString(String indentString) {
        this.mIndentString = indentString;
    }

    private void indent(Writer writer) throws IOException {
        if (null != this.mIndentString) {
            for (int nbElements = this.mObjectStack.size(); nbElements > 0; --nbElements) {
                writer.write(this.mIndentString);
            }
        }
    }

    public void flush() {
        ListIterator<Writer> streamIterator = this.mStreamWriters.listIterator();
        while (streamIterator.hasNext()) {
            Writer writer = streamIterator.next();
            try {
                if (writer == null) continue;
                writer.flush();
            }
            catch (IOException e) {}
        }
    }

    public void close() {
        ListIterator<Writer> streamIterator = this.mStreamWriters.listIterator();
        while (streamIterator.hasNext()) {
            Writer writer = streamIterator.next();
            try {
                if (writer == null) continue;
                writer.close();
            }
            catch (IOException e) {}
        }
    }

    public boolean skipLineFeed() {
        return this.skipLineFeed;
    }

    public void setSkipLineFeed(boolean value) {
        this.skipLineFeed = value;
    }

    protected final class XMLElement {
        private String elementName;
        private boolean declarationCompleted;
        private boolean hasAttributes;
        private boolean hasData;

        public XMLElement(String name) {
            this.elementName = name;
        }

        public void setName(String name) {
            this.elementName = name;
        }

        public void setDeclarationCompleted(boolean value) {
            this.declarationCompleted = value;
        }

        public void setHasAttributes(boolean value) {
            this.hasAttributes = value;
        }

        public String getName() {
            return this.elementName;
        }

        public boolean getDeclarationCompleted() {
            return this.declarationCompleted;
        }

        public boolean getHasAttributes() {
            return this.hasAttributes;
        }

        public void setHasData(boolean value) {
            this.hasData = value;
        }

        public boolean getHasData() {
            return this.hasData;
        }
    }
}

