/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract;

import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.core.extract.ExtractionContext;
import com.ibm.cognos.aurora.core.extract.TabularDataset;
import com.ibm.cognos.aurora.core.extract.TabularDatasetAppender;
import com.ibm.cognos.aurora.core.extract.TabularExtracter;
import com.ibm.cognos.aurora.core.extract.parser.ParseResult;
import com.ibm.cognos.aurora.core.io.BOMDetector;
import com.ibm.cognos.aurora.core.io.FileEncodingDetector;
import com.ibm.cognos.aurora.core.io.LineEndingDetector;
import com.ibm.cognos.aurora.core.util.UniqueNameSet;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CSVExtracter
extends TabularExtracter {
    private static final boolean DEBUG_LOG_INPUT = false;
    private static Pattern COMMA_DELIMITED_PATTERN = Pattern.compile("\"(.+?)\",|([^,]+),?|,");
    private static Pattern SEMI_COLON_DELIMITED_PATTERN = Pattern.compile("\"(.+?)\";|([^;]+);?|;");
    private static Pattern PIPE_DELIMITED_PATTERN = Pattern.compile("\"(.+?)\"\\||([^\\|]+)\\|?|;");
    private static Pattern TAB_DELIMITED_PATTERN = Pattern.compile("[^\t]+|\t(?=\t)|\t$");
    private static final char DELIMITER_COMMA = ',';
    private static final char DELIMITER_SEMI_COLON = ';';
    private static final char DELIMITER_TAB = '\t';
    private static final char DELIMITER_PIPE = '|';
    private char mDelimiter;
    private boolean mHasHeader;
    private int mColumnCount;
    private final boolean mDebugEnabled = logger.isDebugEnabled();

    public CSVExtracter(String filename) throws IOException {
        super(filename);
    }

    public CSVExtracter(File localDataFile) throws IOException {
        super(localDataFile);
    }

    public CSVExtracter(String name, InputStream is) throws IOException {
        super(name, is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractDatasets(ExtractionContext context) {
        context.setDataSourceType("CSVFile");
        context.setNeedsISO6801Reconciliation(true);
        TabularDataset ds = context.createDataset("Dataset", "Unknown");
        StringBuilder logBuf = new StringBuilder();
        try {
            BufferedReader reader = this.openBufferedReader();
            this.determineDelimitingStyle(reader);
            CSVParser csvParser = new CSVParser((Reader)reader, CSVFormat.newBuilder().withCommentStart('\u0000').withDelimiter(this.mDelimiter).withQuoteChar('\"').withIgnoreEmptyLines(true).withIgnoreSurroundingSpaces(true).build());
            this.mHasHeader = true;
            Iterator csvRecords = csvParser.iterator();
            this.extractDataItems((CSVRecord)csvRecords.next(), ds, context);
            TabularDatasetAppender appender = ds.openAppender();
            try {
                IValue[] row = new IValue[ds.numColumns()];
                ParseResult parseResult = new ParseResult();
                while (csvRecords.hasNext()) {
                    for (int i = 0; i < row.length; ++i) {
                        row[i] = null;
                    }
                    CSVRecord csvRecord = (CSVRecord)csvRecords.next();
                    int index = 0;
                    for (int i = 0; i < csvRecord.size() && index < row.length; ++i) {
                        String strValue = csvRecord.get(i);
                        if (null == strValue || strValue.isEmpty()) {
                            ++index;
                            continue;
                        }
                        TabularDataset.ColumnInfo colInfo = ds.getColumn(index);
                        assert (null != colInfo);
                        strValue = ExtractionContext.sanitizeDataText(strValue);
                        context.parseValue(strValue, colInfo.getTabooTypes(), parseResult);
                        row[index++] = parseResult.getValue();
                        for (IValueDecoration decor : parseResult.getDecorations()) {
                            colInfo.addValueDecoration(decor);
                        }
                    }
                    appender.appendRow(row);
                }
            }
            finally {
                appender.close();
            }
            reader.close();
        }
        catch (IOException ioe) {
            logger.error(ioe.getLocalizedMessage(), this.getClass().getName() + "::extractDatasets()");
            throw new ImportException(ioe);
        }
    }

    private BufferedReader openBufferedReader() throws IOException {
        BufferedReader reader;
        Charset charset = FileEncodingDetector.detectCharset(this.getLength(), this.getPath(), this.getInputStream());
        ByteArrayInputStream is = this.getInputStream();
        BOMDetector.BOM bom = BOMDetector.detect(is);
        if (null != bom) {
            is.skip(bom.getByteLength());
        }
        if (LineEndingDetector.detect(reader = new BufferedReader(new InputStreamReader((InputStream)is, charset))) == LineEndingDetector.ELineEnding.CR) {
            return new BufferedReader(new LineFilterReader(reader));
        }
        return reader;
    }

    private void extractDataItems(CSVRecord record, TabularDataset ds, ExtractionContext ctx) throws IOException {
        UniqueNameSet uniqueNames = new UniqueNameSet();
        if (this.mHasHeader) {
            for (int i = 0; i < record.size(); ++i) {
                String label = record.get(i);
                label = null == label || label.length() == 0 ? "Column" : ExtractionContext.sanitizeLabelText(label);
                if (this.mDebugEnabled) {
                    logger.debug("Detected label: " + label, this.getClass().getName() + "::extractDataItems()");
                }
                ds.addColumn(uniqueNames.insert(label), DataTypes.getStringType(1));
            }
        } else {
            for (int i = 0; i < this.mColumnCount; ++i) {
                ds.addColumn("Column " + (i + 1), DataTypes.getStringType(1));
            }
        }
    }

    private void determineDelimitingStyle(BufferedReader reader) throws IOException {
        int nmax = 0;
        reader.mark(4096);
        String sLine = reader.readLine();
        if (sLine == null || sLine.length() == 0) {
            throw new ImportException("Expecting a non-empty first line");
        }
        reader.reset();
        Matcher matchCSV = COMMA_DELIMITED_PATTERN.matcher(sLine);
        int ncsv = 0;
        while (matchCSV.find()) {
            ++ncsv;
        }
        this.mDelimiter = (char)44;
        nmax = ncsv;
        Matcher matchSemiColon = SEMI_COLON_DELIMITED_PATTERN.matcher(sLine);
        int nsemiColon = 0;
        while (matchSemiColon.find()) {
            ++nsemiColon;
        }
        if (nsemiColon > nmax) {
            nmax = nsemiColon;
            this.mDelimiter = (char)59;
        }
        Matcher matchTAB = TAB_DELIMITED_PATTERN.matcher(sLine);
        int ntab = 0;
        while (matchTAB.find()) {
            ++ntab;
        }
        if (ntab > nmax) {
            nmax = ntab;
            this.mDelimiter = (char)9;
        }
        Matcher matchPIPE = PIPE_DELIMITED_PATTERN.matcher(sLine);
        int npipe = 0;
        while (matchPIPE.find()) {
            ++npipe;
        }
        if (npipe > nmax) {
            nmax = npipe;
            this.mDelimiter = (char)124;
        }
        if (nmax == 0) {
            if (logger.isWarnEnabled()) {
                logger.warn("Failed to detect delimeter - assuming comma-separated", this.getClass().getName() + "::determineDelimitingStyle");
            }
        } else if (logger.isInfoEnabled()) {
            logger.info("Detected delimeter: '" + this.mDelimiter + "'", this.getClass().getName() + "::determineDelimitingStyle");
        }
    }

    @Override
    public void close() {
    }

    private static final class LineFilterReader
    extends FilterReader {
        protected LineFilterReader(Reader in) {
            super(in);
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int numRead = super.read(cbuf, off, len);
            if (-1 == numRead) {
                return -1;
            }
            for (int i = 0; i < numRead; ++i) {
                if ('\r' != cbuf[off + i]) continue;
                cbuf[off + i] = 10;
            }
            return numRead;
        }
    }
}

