/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.DecimalType;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.datatype.StringType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.core.extract.TabularDataset;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import java.util.EnumSet;

public class DataTypeResolver {
    private static final int TABOO_SAMPLES = 20;
    private static final double TABOO_RATIO = 0.25;
    private final TabularDataset.ColumnInfo mInfo;
    private long mTotalCount = 0L;
    private final long[] mTypeCounts;
    private int mMaxStringLength = 1;
    private int mMaxPrecision = 1;
    private int mMaxScale = 0;
    private boolean mLongSeen = false;
    private boolean mDoubleSeen = false;
    private boolean mFloatSeen = false;
    private static final ILogger logger = LoggerManager.getLogger("ATHENA.core.aurora_core");

    public DataTypeResolver(TabularDataset.ColumnInfo info) {
        this.mInfo = info;
        this.mTypeCounts = new long[BaseDataType.values().length];
        IDataType initialType = info.getDataType();
        if (!initialType.isUnknown()) {
            int n = initialType.getBaseType().ordinal();
            this.mTypeCounts[n] = this.mTypeCounts[n] + 1L;
            ++this.mTotalCount;
        }
    }

    public void resolve() {
        IDataType bestType;
        if (logger.isInfoEnabled()) {
            logger.info("Resolving data type for column '" + this.mInfo.getName() + "'", this.getClass().getName() + "::resolve()");
        }
        boolean isDebugEnabled = logger.isDebugEnabled();
        long maxCount = Long.MIN_VALUE;
        BaseDataType bestBaseType = this.mInfo.getDataType().getBaseType();
        for (int i = 0; i < this.mTypeCounts.length; ++i) {
            if (this.mTypeCounts[i] > maxCount) {
                maxCount = this.mTypeCounts[i];
                bestBaseType = BaseDataType.values()[i];
            }
            if (this.mTypeCounts[i] <= 0L || !logger.isDebugEnabled() || !isDebugEnabled) continue;
            logger.debug(String.format("Value count for %s is %d", new Object[]{BaseDataType.values()[i], this.mTypeCounts[i]}), this.getClass().getName() + "::resolve()");
        }
        switch (bestBaseType) {
            case INTEGER: {
                if (this.mDoubleSeen) {
                    bestBaseType = BaseDataType.DOUBLE;
                    break;
                }
                if (this.mFloatSeen) {
                    bestBaseType = BaseDataType.FLOAT;
                    break;
                }
                if (!this.mLongSeen) break;
                bestBaseType = BaseDataType.LONG;
                break;
            }
            case LONG: {
                if (!this.mFloatSeen && !this.mDoubleSeen) break;
                bestBaseType = BaseDataType.DOUBLE;
                break;
            }
            case FLOAT: {
                if (!this.mDoubleSeen && !this.mLongSeen) break;
                bestBaseType = BaseDataType.DOUBLE;
                break;
            }
            case BOOLEAN: {
                if (this.mTypeCounts[BaseDataType.STRING.ordinal()] <= 0L) break;
                bestBaseType = BaseDataType.STRING;
            }
        }
        if (isDebugEnabled) {
            logger.debug("Best candidate base type is " + bestBaseType.name(), this.getClass().getName() + "::resolve()");
        }
        if ((bestType = DataTypes.fromBaseType(bestBaseType)).isString()) {
            bestType = ((StringType)bestType).withMaxLength(this.mMaxStringLength);
            if (isDebugEnabled) {
                logger.debug("Using max string length " + this.mMaxStringLength, this.getClass().getName() + "::resolve()");
            }
        } else if (bestType.getBaseType() == BaseDataType.DECIMAL) {
            bestType = ((DecimalType)bestType).withPrecisionAndScale(this.mMaxPrecision, this.mMaxScale);
            if (isDebugEnabled) {
                logger.debug(String.format("Using precision %d and scale %d", this.mMaxPrecision, this.mMaxScale), this.getClass().getName() + "::resolve()");
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Resolved type: " + bestType.toString(), this.getClass().getName() + "::resolve()");
        }
        this.mInfo.setDataType(bestType);
    }

    public void visit(IValue v) {
        if (null == v || !v.isOK() || v.getType().isUnknown()) {
            return;
        }
        IDataType dt = v.getType();
        BaseDataType baseType = dt.getBaseType();
        int n = baseType.ordinal();
        this.mTypeCounts[n] = this.mTypeCounts[n] + 1L;
        ++this.mTotalCount;
        if (this.mTotalCount == 20L) {
            if (logger.isDebugEnabled()) {
                logger.debug("Determining taboo types for column '" + this.mInfo.getName() + "'", this.getClass().getName() + "::visit()");
            }
            EnumSet<BaseDataType> tabooTypes = this.mInfo.getTabooTypes();
            tabooTypes.clear();
            for (BaseDataType t : BaseDataType.values()) {
                double ratio = (double)this.mTypeCounts[t.ordinal()] / (double)this.mTotalCount;
                if (!(ratio < 0.25)) continue;
                tabooTypes.add(t);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Final taboo set: " + tabooTypes.toString(), this.getClass().getName() + "::visit()");
                logger.debug("Complement set: " + EnumSet.complementOf(tabooTypes).toString(), this.getClass().getName() + "::visit()");
            }
        }
        this.mMaxStringLength = Math.max(this.mMaxStringLength, DataTypes.getStringLength(dt));
        switch (dt.getBaseType()) {
            case DECIMAL: {
                DecimalType decType = (DecimalType)dt;
                int scaleDiff = decType.getScale() - this.mMaxScale;
                this.mMaxPrecision = scaleDiff > 0 ? Math.max(this.mMaxPrecision + scaleDiff, decType.getPrecision()) : Math.max(this.mMaxPrecision, decType.getPrecision() - scaleDiff);
                this.mMaxScale = Math.max(this.mMaxScale, decType.getScale());
                break;
            }
            case FLOAT: {
                this.mFloatSeen = true;
                break;
            }
            case DOUBLE: {
                this.mDoubleSeen = true;
                break;
            }
            case LONG: {
                this.mLongSeen = true;
            }
        }
    }
}

