/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract;

import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.core.bvt.IBVTable;
import com.ibm.cognos.aurora.core.bvt.heap.HeapBVTable;
import com.ibm.cognos.aurora.core.bvt.hybrid.HybridBVTable;
import com.ibm.cognos.aurora.core.extract.TabularDataset;
import com.ibm.cognos.aurora.core.extract.parser.BooleanParser;
import com.ibm.cognos.aurora.core.extract.parser.CurrencyParser;
import com.ibm.cognos.aurora.core.extract.parser.DateParser;
import com.ibm.cognos.aurora.core.extract.parser.NumberParser;
import com.ibm.cognos.aurora.core.extract.parser.ParseResult;
import com.ibm.cognos.aurora.core.extract.parser.PercentParser;
import com.ibm.cognos.aurora.core.extract.parser.TimeParser;
import com.ibm.cognos.aurora.core.extract.parser.TimestampParser;
import com.ibm.cognos.aurora.core.extract.parser.UberParser;
import com.ibm.cognos.aurora.core.io.TempFile;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExtractionContext {
    private final String mTempDirPath;
    private final ULocale mLocale;
    private final List<String> mNullTokens;
    private final ThreadLocal<UberParser> mUberParser;
    private final LinkedHashMap<String, TabularDataset> mDatasetsByName = new LinkedHashMap();
    private String mDataSourceName;
    private String mDataSourceType;
    private final Map<String, IValue> mDataSourceProperties = new HashMap<String, IValue>();
    private boolean mNeedsISO6801Reconciliation = false;
    private static final ILogger logger;
    private final boolean mDebugEnabled;

    public ExtractionContext(String tempDirPath, ULocale locale, List<String> nullTokens) {
        this.mTempDirPath = tempDirPath;
        this.mLocale = locale;
        this.mNullTokens = nullTokens;
        this.mUberParser = new ThreadLocal<UberParser>(){

            @Override
            public UberParser initialValue() {
                UberParser result = new UberParser();
                result.addParser(new BooleanParser(ExtractionContext.this.mLocale));
                result.addParser(new NumberParser(ExtractionContext.this.mLocale));
                result.addParser(new CurrencyParser(ExtractionContext.this.mLocale));
                result.addParser(new PercentParser(ExtractionContext.this.mLocale));
                result.addParser(new DateParser(ExtractionContext.this.mLocale));
                result.addParser(new TimeParser(ExtractionContext.this.mLocale));
                result.addParser(new TimestampParser(ExtractionContext.this.mLocale));
                return result;
            }
        };
        this.mDebugEnabled = logger.isDebugEnabled();
    }

    public ULocale getLocale() {
        return this.mLocale;
    }

    public List<String> getNullTokens() {
        return this.mNullTokens;
    }

    public String getDataSourceName() {
        return this.mDataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.mDataSourceName = dataSourceName;
    }

    public String getDataSourceType() {
        return this.mDataSourceType;
    }

    public void setDataSourceType(String dataSourceType) {
        this.mDataSourceType = dataSourceType;
    }

    public Map<String, IValue> getDataSourceProperties() {
        return this.mDataSourceProperties;
    }

    public boolean getNeedsISO6801Reconciliation() {
        return this.mNeedsISO6801Reconciliation;
    }

    public void setNeedsISO6801Reconciliation(boolean value) {
        this.mNeedsISO6801Reconciliation = value;
    }

    public int numDatasets() {
        return this.mDatasetsByName.size();
    }

    public TabularDataset[] getAllDatasets() {
        return this.mDatasetsByName.values().toArray(new TabularDataset[0]);
    }

    public Set<String> getAllDatasetNames() {
        return Collections.unmodifiableSet(this.mDatasetsByName.keySet());
    }

    public TabularDataset getDataset(String datasetName) {
        return this.mDatasetsByName.get(datasetName);
    }

    public boolean removeDataset(String datasetName) {
        TabularDataset dataset = (TabularDataset)this.mDatasetsByName.remove(datasetName);
        if (null != dataset) {
            dataset.dispose();
            return true;
        }
        return false;
    }

    public TabularDataset createDataset(String datasetName, String datasetType) {
        if (this.mDatasetsByName.containsKey(datasetName)) {
            throw new ImportException("Duplicate dataset: " + datasetName);
        }
        File dataDir = null;
        IBVTable table = null;
        if (this.mTempDirPath != null) {
            try {
                dataDir = TempFile.createTempSubDirectory(new File(this.mTempDirPath), "dataSet_");
                table = new HybridBVTable(dataDir.getAbsolutePath());
            }
            catch (IOException ex) {
                throw new ImportException(ex);
            }
        } else {
            table = new HeapBVTable();
        }
        TabularDataset ds = new TabularDataset(table, datasetName, datasetType);
        this.mDatasetsByName.put(datasetName, ds);
        return ds;
    }

    public TabularDataset detachDataset(String datasetName) {
        return (TabularDataset)this.mDatasetsByName.remove(datasetName);
    }

    public boolean isNullValue(String text) {
        for (int i = 0; i < this.mNullTokens.size(); ++i) {
            if (!this.mNullTokens.get(i).equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    public void parseValue(String text, ParseResult result) {
        this.parseValue(text, null, result);
    }

    public void parseValue(String text, EnumSet<BaseDataType> tabooTypes, ParseResult result) {
        result.setValue(null);
        result.getDecorations().clear();
        if (this.isNullValue(text)) {
            result.setValue(ValueFactory.createString(null));
            return;
        }
        this.mUberParser.get().parse(text, tabooTypes, result);
        if (null == result.getValue()) {
            result.setValue(ValueFactory.createString(text));
            if (this.mDebugEnabled) {
                logger.debug("Could not parse non-string value from: '" + text + "'", this.getClass().getName() + "::parseValue");
            }
        }
    }

    public static String sanitizeLabelText(String text) {
        return ExtractionContext.substituteLineBreaks(ExtractionContext.substituteControlChars(text.trim()));
    }

    public static String sanitizeDataText(String text) {
        return ExtractionContext.substituteControlChars(text);
    }

    private static String substituteLineBreaks(String text) {
        int length = text.length();
        if (length == 0) {
            return text;
        }
        char[] chars = new char[length + 1];
        int newLen = 0;
        text.getChars(0, length, chars, 0);
        chars[length] = '\u0000';
        block3: for (int i = 0; i < length; ++i) {
            char ch = chars[i];
            switch (ch) {
                case '\n': 
                case '\r': 
                case '\u0085': {
                    chars[newLen++] = 32;
                    continue block3;
                }
                default: {
                    chars[newLen++] = ch;
                }
            }
        }
        return new String(chars, 0, newLen);
    }

    private static String substituteControlChars(String text) {
        int length = text.length();
        if (length == 0) {
            return text;
        }
        char[] chars = new char[length + 1];
        int newLen = -1;
        text.getChars(0, length, chars, 0);
        chars[length] = '\u0000';
        while (chars[++newLen] >= ' ') {
        }
        for (int i = newLen; i < length; ++i) {
            boolean keepControlChar;
            int ch = chars[i];
            switch (ch) {
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 133: {
                    keepControlChar = true;
                    break;
                }
                default: {
                    keepControlChar = false;
                }
            }
            chars[newLen++] = keepControlChar || ch >= 32 ? ch : 63;
        }
        return new String(chars, 0, newLen);
    }

    public void dispose() {
        for (TabularDataset ds : this.mDatasetsByName.values()) {
            ds.dispose();
        }
        this.mDatasetsByName.clear();
    }

    static {
        ParseResult result = new ParseResult();
        new BooleanParser(ULocale.ENGLISH).parse("true", result);
        new NumberParser(ULocale.ENGLISH).parse("10", result);
        new CurrencyParser(ULocale.ENGLISH).parse("$10", result);
        new PercentParser(ULocale.ENGLISH).parse("10%", result);
        new DateParser(ULocale.ENGLISH).parse("01/01/2013", result);
        new TimeParser(ULocale.ENGLISH).parse("12:00:00", result);
        new TimestampParser(ULocale.ENGLISH).parse("01/01/2013 12:00:00", result);
        logger = LoggerManager.getLogger("ATHENA.core.aurora_core");
    }
}

