/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract;

import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.decor.IValueDecoration;
import com.ibm.cognos.aurora.api.query.data.IValueIterator;
import com.ibm.cognos.aurora.core.bvt.IBVColumn;
import com.ibm.cognos.aurora.core.bvt.IBVTable;
import com.ibm.cognos.aurora.core.extract.TabularDatasetAppender;
import com.ibm.cognos.aurora.core.extract.TabularDatasetReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TabularDataset {
    private final IBVTable mTableData;
    private final String mDatasetName;
    private final String mDatasetType;
    private final Map<String, IValue> mDatasetProperies = new HashMap<String, IValue>();
    private final List<ColumnInfo> mColumns = new ArrayList<ColumnInfo>();

    public TabularDataset(IBVTable tableData, String datasetName, String datasetType) {
        this.mTableData = tableData;
        this.mDatasetName = datasetName;
        this.mDatasetType = datasetType;
    }

    public IBVTable getTableData() {
        return this.mTableData;
    }

    public String getDatasetName() {
        return this.mDatasetName;
    }

    public String getDatasetType() {
        return this.mDatasetType;
    }

    public Map<String, IValue> getDatasetProperties() {
        return this.mDatasetProperies;
    }

    public int numColumns() {
        return this.mTableData.numColumns();
    }

    public long numRows() {
        return this.mTableData.numRows();
    }

    public ColumnInfo addColumn(String name, IDataType initialDataType) {
        IBVColumn colData = this.mTableData.newColumn();
        ColumnInfo colInfo = new ColumnInfo(name, colData, initialDataType);
        this.mColumns.add(colInfo);
        return colInfo;
    }

    public void removeColumn(String name) {
        int colIdx = this.indexOfColumn(name);
        if (-1 == colIdx) {
            throw new ImportException("Column not found: " + name);
        }
        this.mColumns.remove(colIdx);
        this.mTableData.dropColumn(colIdx);
    }

    public int indexOfColumn(String name) {
        for (int i = 0; i < this.mColumns.size(); ++i) {
            if (!this.mColumns.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public ColumnInfo[] getColumns() {
        return this.mColumns.toArray(new ColumnInfo[0]);
    }

    public String[] getColumnNames() {
        String[] names = new String[this.mColumns.size()];
        for (int i = 0; i < this.mColumns.size(); ++i) {
            names[i] = this.mColumns.get(i).getName();
        }
        return names;
    }

    public ColumnInfo getColumn(String name) {
        int colIdx = this.indexOfColumn(name);
        if (-1 == colIdx) {
            return null;
        }
        return this.mColumns.get(colIdx);
    }

    public ColumnInfo getColumn(int index) {
        return this.mColumns.get(index);
    }

    public TabularDatasetAppender openAppender() {
        try {
            ColumnInfo[] columnInfos = new ColumnInfo[this.numColumns()];
            for (int i = 0; i < columnInfos.length; ++i) {
                columnInfos[i] = this.getColumn(i);
            }
            return new TabularDatasetAppender(columnInfos, this.mTableData.openAppender());
        }
        catch (IOException ex) {
            throw new ImportException(ex);
        }
    }

    public TabularDatasetReader openReader() {
        try {
            return new TabularDatasetReader(this.mTableData.openReader(), this.mTableData.numRows());
        }
        catch (IOException ex) {
            throw new ImportException(ex);
        }
    }

    public void dispose() {
        this.mColumns.clear();
        this.mTableData.dispose();
    }

    public String toString() {
        return this.mColumns.toString();
    }

    public final class ColumnInfo {
        private String mName;
        private IBVColumn mColumnData;
        private final EnumSet<BaseDataType> mTabooTypes;
        private IDataType mDataType;
        private long mNullCount = 0L;
        private long mNonNullCount = 0L;
        private final List<IValueDecoration> mValueDecorations = new ArrayList<IValueDecoration>(2);

        ColumnInfo(String name, IBVColumn columnData, IDataType initalDataType) {
            this.mName = name;
            this.mColumnData = columnData;
            this.mTabooTypes = EnumSet.noneOf(BaseDataType.class);
            this.mDataType = null != initalDataType ? initalDataType : DataTypes.getUnknownType();
        }

        public IBVColumn getColumnData() {
            return this.mColumnData;
        }

        public IValueIterator openIterator() throws IOException {
            return this.mColumnData.openIterator();
        }

        public EnumSet<BaseDataType> getTabooTypes() {
            return this.mTabooTypes;
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public IDataType getDataType() {
            return this.mDataType;
        }

        public void setDataType(IDataType dataType) {
            this.mDataType = null == dataType ? DataTypes.getUnknownType() : dataType;
        }

        public long getNullCount() {
            return this.mNullCount;
        }

        public long getNonNullCount() {
            return this.mNonNullCount;
        }

        public void incrementNullCount(int step) {
            this.mNullCount += (long)step;
        }

        public void setNullCount(long value) {
            this.mNullCount = value;
        }

        public void incrementNonNullCount(int step) {
            this.mNonNullCount += (long)step;
        }

        public void setNonNullCount(long value) {
            this.mNonNullCount = value;
        }

        public IValueDecoration[] getValueDecorations() {
            return this.mValueDecorations.toArray(new IValueDecoration[0]);
        }

        public void addValueDecoration(IValueDecoration decoration) {
            if (!this.mValueDecorations.contains(decoration)) {
                this.mValueDecorations.add(decoration);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.mName).append('(').append(this.mDataType).append(')');
            return sb.toString();
        }
    }
}

