/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract;

import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.core.bvt.IBVTableReader;
import java.io.IOException;

public class TabularDatasetReader {
    private final IBVTableReader mTableReader;
    private final long mRowCount;
    private long mCurrentRowNumber = -1L;

    protected TabularDatasetReader(IBVTableReader tableReader, long rowCount) {
        this.mTableReader = tableReader;
        this.mRowCount = rowCount;
    }

    public long getCurrentRowNumber() {
        return this.mCurrentRowNumber;
    }

    public IValue[] readRowAt(long rowNumber) {
        if (rowNumber >= this.mRowCount) {
            throw new IndexOutOfBoundsException();
        }
        try {
            IValue[] row = this.mTableReader.rowAt(rowNumber);
            this.mCurrentRowNumber = rowNumber;
            return row;
        }
        catch (IOException ex) {
            throw new ImportException(ex);
        }
    }

    public boolean hasNext() {
        return this.mCurrentRowNumber + 1L < this.mRowCount;
    }

    public IValue[] readNextRow() {
        if (!this.hasNext()) {
            return null;
        }
        try {
            IValue[] row = this.mTableReader.nextRow();
            ++this.mCurrentRowNumber;
            return row;
        }
        catch (IOException ex) {
            throw new ImportException(ex);
        }
    }

    public void reset() {
        this.mCurrentRowNumber = -1L;
        try {
            this.mTableReader.reset();
        }
        catch (IOException ex) {
            throw new ImportException(ex);
        }
    }

    public void close() {
        try {
            this.mTableReader.close();
        }
        catch (IOException ex) {
            throw new ImportException(ex);
        }
    }
}

