/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract;

import com.ibm.cognos.aurora.core.extract.ExtractionContext;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.utils.IOUtils;

public abstract class TabularExtracter {
    protected static final ILogger logger = LoggerManager.getLogger("ATHENA.core.aurora_core");
    private final String mName;
    private final String mPath;
    private final byte[] mData;

    protected TabularExtracter(String filename) throws IOException {
        this(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TabularExtracter(File file) throws IOException {
        this.mName = file.getName();
        this.mPath = file.getAbsolutePath();
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            this.mData = IOUtils.toByteArray((InputStream)is);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    protected TabularExtracter(String name, InputStream is) throws IOException {
        this.mName = name;
        this.mData = IOUtils.toByteArray((InputStream)is);
        this.mPath = name;
    }

    protected TabularExtracter(String name, byte[] data) {
        this.mData = data;
        this.mName = name;
        this.mPath = name;
    }

    public ByteArrayInputStream getInputStream() {
        return new ByteArrayInputStream(this.mData);
    }

    public long getLength() {
        return this.mData.length;
    }

    public String getName() {
        return this.mName;
    }

    public String getPath() {
        return this.mPath;
    }

    public abstract void extractDatasets(ExtractionContext var1);

    public abstract void close();
}

