/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract;

import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.importer.importspec.EDocumentType;
import com.ibm.cognos.aurora.core.extract.CSVExtracter;
import com.ibm.cognos.aurora.core.extract.TabularExtracter;
import com.ibm.cognos.aurora.core.extract.XLSExtracter;
import com.ibm.cognos.aurora.core.extract.XLSXExtracter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;

public final class TabularExtracterFactory {
    public static TabularExtracter create(String originalFileName, EDocumentType docType, Properties configProps) throws ImportException {
        return TabularExtracterFactory.create(originalFileName, new File(originalFileName), docType, configProps);
    }

    public static TabularExtracter create(String originalFileName, InputStream is, EDocumentType docType, Properties configProps) throws ImportException {
        if ((null == docType || EDocumentType.AUTO == docType) && null == (docType = TabularExtracterFactory.determineDocType(originalFileName))) {
            throw new ImportException("Unsupported document type: " + originalFileName);
        }
        try {
            switch (docType) {
                case CSV: {
                    return new CSVExtracter(originalFileName, is);
                }
                case EXCEL97: {
                    return new XLSExtracter(originalFileName, is);
                }
                case EXCEL07: {
                    return new XLSXExtracter(originalFileName, is);
                }
            }
            throw new ImportException("Unsupported document type: " + originalFileName);
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
    }

    public static TabularExtracter create(String originalFileName, File localDataFile, EDocumentType docType, Properties configProps) throws ImportException {
        if ((null == docType || EDocumentType.AUTO == docType) && null == (docType = TabularExtracterFactory.determineDocType(originalFileName))) {
            throw new ImportException("Unsupported document type: " + originalFileName);
        }
        try {
            switch (docType) {
                case CSV: {
                    return new CSVExtracter(localDataFile);
                }
                case EXCEL97: {
                    return new XLSExtracter(localDataFile);
                }
                case EXCEL07: {
                    return new XLSXExtracter(localDataFile);
                }
            }
            throw new ImportException("Unsupported document type: " + originalFileName);
        }
        catch (IOException e) {
            throw new ImportException(e);
        }
    }

    private static EDocumentType determineDocType(String fileName) {
        if (null == fileName || 0 == fileName.length()) {
            throw new IllegalArgumentException("File name was missing");
        }
        String extension = FilenameUtils.getExtension((String)fileName).toLowerCase();
        if (0 == extension.length()) {
            return null;
        }
        if ("csv".equals(extension) || "txt".equals(extension)) {
            return EDocumentType.CSV;
        }
        if ("xls".equals(extension)) {
            return EDocumentType.EXCEL97;
        }
        if ("xlsx".equals(extension)) {
            return EDocumentType.EXCEL07;
        }
        return null;
    }

    private TabularExtracterFactory() {
    }
}

