/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract;

import com.ibm.cognos.aurora.api.importer.ImportException;
import com.ibm.cognos.aurora.api.model.datatype.DataTypes;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.aurora.api.model.value.ValueBase;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.model.value.decor.ValueDecorations;
import com.ibm.cognos.aurora.core.extract.ExtractionContext;
import com.ibm.cognos.aurora.core.extract.TabularDataset;
import com.ibm.cognos.aurora.core.extract.TabularDatasetAppender;
import com.ibm.cognos.aurora.core.extract.TabularExtracter;
import com.ibm.cognos.aurora.core.extract.XLSExtracterCommon;
import com.ibm.icu.util.Currency;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class XLSExtracter
extends TabularExtracter {
    private Map<Integer, String> mFormatIdToString = new HashMap<Integer, String>();

    public XLSExtracter(String filename) throws IOException {
        super(filename);
        this.cacheBuiltinFormats();
    }

    public XLSExtracter(File localDataFile) throws IOException {
        super(localDataFile);
        this.cacheBuiltinFormats();
    }

    public XLSExtracter(String name, InputStream is) throws IOException {
        super(name, is);
        this.cacheBuiltinFormats();
    }

    private void cacheBuiltinFormats() {
        for (int fid = 0; fid < HSSFDataFormat.getNumberOfBuiltinBuiltinFormats(); ++fid) {
            String formatStr = HSSFDataFormat.getBuiltinFormat((short)((short)fid));
            this.mFormatIdToString.put(fid, formatStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extractDatasets(ExtractionContext context) {
        context.setDataSourceType("Excel97File");
        Listener listener = new Listener(context);
        try {
            POIFSFileSystem poifs = new POIFSFileSystem((InputStream)this.getInputStream());
            DocumentInputStream din = poifs.createDocumentInputStream("Workbook");
            try {
                HSSFRequest req = new HSSFRequest();
                req.addListenerForAllRecords((HSSFListener)listener);
                HSSFEventFactory factory = new HSSFEventFactory();
                factory.processEvents(req, (InputStream)din);
            }
            finally {
                din.close();
            }
        }
        catch (IOException ex) {
            throw new ImportException(ex);
        }
        finally {
            listener.endOfData();
        }
    }

    @Override
    public void close() {
    }

    private final class Listener
    implements HSSFListener {
        private final ExtractionContext mContext;
        private TabularDataset mCurrentDataset;
        private TabularDatasetAppender mCurrentAppender;
        private IValue[] mCurrentRow;
        private boolean mRowDataRead = false;
        private final List<String> mSheetNames = new ArrayList<String>();
        private int mSheetRefIdx = 0;
        private SSTRecord mStringPool;
        private int mLastRowIdx = -1;
        private int mLastSID;
        private FormulaRecord mStringFormulaRecord;
        private int mColumnCount = 0;
        private Map<Integer, Integer> mXFormatIdToFormatId = new HashMap<Integer, Integer>();
        private short mXFormatRecCount = 0;
        private XLSExtracterCommon mHelper = new XLSExtracterCommon();

        Listener(ExtractionContext context) {
            this.mContext = context;
        }

        public void processRecord(Record record) {
            switch (record.getSid()) {
                case 2057: {
                    BOFRecord bof = (BOFRecord)record;
                    if (bof.getType() != 16) break;
                    if (null != this.mCurrentRow && this.mRowDataRead) {
                        if (null == this.mCurrentAppender) {
                            this.mCurrentAppender = this.mCurrentDataset.openAppender();
                        }
                        this.mCurrentAppender.appendRow(this.mCurrentRow);
                    }
                    if (null != this.mCurrentAppender) {
                        this.mCurrentAppender.close();
                        this.mCurrentAppender = null;
                    }
                    this.mCurrentDataset = this.mContext.getDataset(this.mSheetNames.get(this.mSheetRefIdx));
                    this.mColumnCount = 0;
                    this.mCurrentRow = null;
                    this.mRowDataRead = false;
                    ++this.mSheetRefIdx;
                    this.mLastRowIdx = -1;
                    this.mHelper.clearNames();
                    break;
                }
                case 133: {
                    BoundSheetRecord bsr = (BoundSheetRecord)record;
                    this.mSheetNames.add(bsr.getSheetname());
                    this.mContext.createDataset(bsr.getSheetname(), "WorkSheet");
                    break;
                }
                case 520: {
                    break;
                }
                case 515: {
                    NumberRecord numrec = (NumberRecord)record;
                    double numValue = numrec.getValue();
                    if (numrec.getRow() == 0) {
                        this.addDataItem(numrec.getColumn(), Long.toString((long)numValue));
                        break;
                    }
                    this.addRowIfRequired((CellRecord)numrec);
                    IValue value = this.makeValue(numValue, (CellRecord)numrec);
                    this.recordDataPoint(numrec.getColumn(), value);
                    break;
                }
                case 252: {
                    this.mStringPool = (SSTRecord)record;
                    break;
                }
                case 253: {
                    LabelSSTRecord lrec = (LabelSSTRecord)record;
                    UnicodeString unicodeStr = this.mStringPool.getString(lrec.getSSTIndex());
                    String columnValue = unicodeStr.getString();
                    columnValue = ExtractionContext.sanitizeDataText(columnValue);
                    if (lrec.getRow() == 0) {
                        this.addDataItem(lrec.getColumn(), columnValue);
                        break;
                    }
                    if (lrec.getColumn() > this.mColumnCount) break;
                    this.addRowIfRequired((CellRecord)lrec);
                    if (this.mContext.isNullValue(columnValue)) {
                        this.recordDataPoint(lrec.getColumn(), ValueFactory.createString(null));
                        break;
                    }
                    this.recordDataPoint(lrec.getColumn(), XLSExtracterCommon.valueFromString(columnValue, this.mContext));
                    break;
                }
                case 6: {
                    FormulaRecord frec = (FormulaRecord)record;
                    double formValue = frec.getValue();
                    if (frec.getRow() == 0) {
                        this.addDataItem(frec.getColumn(), Double.toString(formValue));
                        break;
                    }
                    if (frec.hasCachedResultString()) {
                        this.mStringFormulaRecord = frec;
                        break;
                    }
                    this.addRowIfRequired((CellRecord)frec);
                    IValue value = this.makeValue(formValue, (CellRecord)frec);
                    this.recordDataPoint(frec.getColumn(), value);
                    break;
                }
                case 519: {
                    if (this.mLastSID != 6) break;
                    StringRecord srec = (StringRecord)record;
                    String vFormula = srec.getString();
                    this.addRowIfRequired((CellRecord)this.mStringFormulaRecord);
                    if (this.mContext.isNullValue(vFormula)) {
                        this.recordDataPoint(this.mStringFormulaRecord.getColumn(), ValueFactory.createString(null));
                        break;
                    }
                    this.recordDataPoint(this.mStringFormulaRecord.getColumn(), ValueFactory.createString(vFormula));
                    break;
                }
                case 1054: {
                    FormatRecord formrec = (FormatRecord)record;
                    XLSExtracter.this.mFormatIdToString.put(formrec.getIndexCode(), formrec.getFormatString());
                    break;
                }
                case 224: {
                    ExtendedFormatRecord xformrec = (ExtendedFormatRecord)record;
                    short s = this.mXFormatRecCount;
                    this.mXFormatRecCount = (short)(s + 1);
                    short xformId = s;
                    this.mXFormatIdToFormatId.put(Integer.valueOf(xformId), Integer.valueOf(xformrec.getFormatIndex()));
                    break;
                }
            }
            this.mLastSID = record.getSid();
        }

        private IValue makeValue(double dValue, CellRecord record) {
            TabularDataset.ColumnInfo colInfo = this.mCurrentDataset.getColumn(record.getColumn());
            Integer formId = this.mXFormatIdToFormatId.get(record.getXFIndex());
            String formStr = (String)XLSExtracter.this.mFormatIdToString.get(formId);
            boolean isValidDate = HSSFDateUtil.isValidExcelDate((double)dValue);
            boolean hasDate = isValidDate && XLSExtracterCommon.hasDateFormatting(formStr);
            boolean hasTime = isValidDate && XLSExtracterCommon.hasTimeFormatting(formStr);
            ValueBase value = null;
            if (hasDate) {
                value = hasTime ? ValueFactory.createTimestamp(HSSFDateUtil.getJavaDate((double)dValue)) : ValueFactory.createDate(HSSFDateUtil.getJavaDate((double)dValue));
            } else if (hasTime) {
                value = ValueFactory.createTime(HSSFDateUtil.getJavaDate((double)dValue));
            } else if (XLSExtracterCommon.hasCurrencyFormatting(formStr)) {
                BigDecimal bd = BigDecimal.valueOf(dValue);
                int wholeDigits = bd.precision() - bd.scale();
                int newPrecision = wholeDigits + 4;
                value = ValueFactory.createDecimal(bd.round(new MathContext(newPrecision)));
                for (Currency curr : XLSExtracterCommon.extractCurrenciesFromFormat(formStr, this.mContext.getLocale())) {
                    colInfo.addValueDecoration(ValueDecorations.getCurrencyDecoration(curr));
                }
            } else {
                value = XLSExtracterCommon.hasDecimalPortion(dValue) ? ValueFactory.createDouble(dValue) : ValueFactory.createLong((long)dValue);
                if (XLSExtracterCommon.hasPercentFormatting(formStr)) {
                    colInfo.addValueDecoration(ValueDecorations.getPercentDecoration('%'));
                }
            }
            if (value.getType().isNumeric() && XLSExtracterCommon.hasThousandsGroupedFormatting(formStr)) {
                colInfo.addValueDecoration(ValueDecorations.geThousandsSeparatorDecoration(','));
            }
            return value;
        }

        private void addDataItem(int columnIdx, String heading) {
            boolean firstColIdx = false;
            String uniqueHeading = null;
            for (int i = this.mColumnCount; i < columnIdx - 0; ++i) {
                uniqueHeading = this.mHelper.makeNameUnique("Column");
                this.mCurrentDataset.addColumn(uniqueHeading, DataTypes.getUnknownType());
                ++this.mColumnCount;
            }
            heading = ExtractionContext.sanitizeLabelText(heading);
            uniqueHeading = this.mHelper.makeNameUnique(heading);
            this.mCurrentDataset.addColumn(uniqueHeading, DataTypes.getUnknownType());
            ++this.mColumnCount;
        }

        private void addRowIfRequired(CellRecord rec) {
            int rowsSkipped;
            if (null == this.mCurrentRow) {
                this.mCurrentRow = new IValue[this.mColumnCount];
                this.mLastRowIdx = rec.getRow();
            }
            if ((rowsSkipped = rec.getRow() - this.mLastRowIdx) > 0) {
                int i;
                if (this.mRowDataRead) {
                    if (null == this.mCurrentAppender) {
                        this.mCurrentAppender = this.mCurrentDataset.openAppender();
                    }
                    this.mCurrentAppender.appendRow(this.mCurrentRow);
                    for (i = 0; i < this.mCurrentRow.length; ++i) {
                        this.mCurrentRow[i] = null;
                    }
                    this.mRowDataRead = false;
                    --rowsSkipped;
                }
                while (rowsSkipped > 0) {
                    if (null == this.mCurrentAppender) {
                        this.mCurrentAppender = this.mCurrentDataset.openAppender();
                    }
                    this.mCurrentAppender.appendRow(this.mCurrentRow);
                    for (i = 0; i < this.mCurrentRow.length; ++i) {
                        this.mCurrentRow[i] = null;
                    }
                    --rowsSkipped;
                }
                this.mLastRowIdx = rec.getRow();
            }
        }

        private void recordDataPoint(short colIdx, IValue dataValue) {
            if (colIdx >= this.mCurrentRow.length) {
                throw new ImportException("The data format currently supported is limited to a single table per sheet, and the column heading must appear on the first row. Please check you dataset!");
            }
            this.mCurrentRow[colIdx] = dataValue;
            this.mRowDataRead = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endOfData() {
            try {
                if (this.mRowDataRead) {
                    if (null == this.mCurrentAppender) {
                        this.mCurrentAppender = this.mCurrentDataset.openAppender();
                    }
                    this.mCurrentAppender.appendRow(this.mCurrentRow);
                    this.mRowDataRead = false;
                }
            }
            finally {
                this.mCurrentRow = null;
                try {
                    if (null != this.mCurrentAppender) {
                        this.mCurrentAppender.close();
                    }
                }
                finally {
                    this.mCurrentAppender = null;
                }
            }
        }
    }
}

