/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract.parser;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.core.extract.parser.ITextParser;
import com.ibm.cognos.aurora.core.extract.parser.ParseResult;
import com.ibm.icu.util.ULocale;
import java.util.EnumSet;
import java.util.Locale;

public class BooleanParser
implements ITextParser {
    private static final String[] TRUE_TOKENS = new String[]{"true", "yes"};
    private static final String[] FALSE_TOKENS = new String[]{"false", "no"};
    private final Locale mJDKLocale;

    public BooleanParser(ULocale locale) {
        this.mJDKLocale = locale.toLocale();
    }

    @Override
    public void parse(String text, ParseResult result) {
        this.parse(text, null, result);
    }

    @Override
    public void parse(String text, EnumSet<BaseDataType> tabooTypes, ParseResult result) {
        result.setValue(null);
        result.getDecorations().clear();
        if (null == text || text.length() == 0) {
            return;
        }
        if (null != tabooTypes && tabooTypes.contains((Object)BaseDataType.BOOLEAN)) {
            return;
        }
        text = text.trim();
        String lcaseText = text.toLowerCase(this.mJDKLocale);
        for (String tok : TRUE_TOKENS) {
            if (!tok.equals(lcaseText)) continue;
            result.setValue(ValueFactory.createBoolean(true));
            return;
        }
        for (String tok : FALSE_TOKENS) {
            if (!tok.equals(lcaseText)) continue;
            result.setValue(ValueFactory.createBoolean(false));
            return;
        }
    }
}

