/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract.parser;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.value.DoubleValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.model.value.decor.ValueDecorations;
import com.ibm.cognos.aurora.core.extract.parser.ITextParser;
import com.ibm.cognos.aurora.core.extract.parser.ParseResult;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.text.ParsePosition;
import java.util.EnumSet;

public final class NumberParser
implements ITextParser {
    private static final char NON_BREAK_SPACE = '\u00a0';
    private static final char BREAK_SPACE = ' ';
    private static EnumSet<BaseDataType> NUMBER_TYPES;
    private final NumberFormat mFormat;
    private final DecimalFormatSymbols mFormatSymbols;

    public NumberParser(ULocale locale) {
        this.mFormat = NumberFormat.getInstance((ULocale)locale);
        this.mFormatSymbols = ((DecimalFormat)this.mFormat).getDecimalFormatSymbols();
    }

    @Override
    public void parse(String text, ParseResult result) {
        this.parse(text, null, result);
    }

    @Override
    public void parse(String text, EnumSet<BaseDataType> tabooTypes, ParseResult result) {
        ParsePosition pos;
        Number num;
        boolean hasTrailingClosingBracket;
        result.setValue(null);
        result.getDecorations().clear();
        if (null == text || text.length() == 0) {
            return;
        }
        if (null != tabooTypes && tabooTypes.containsAll(NUMBER_TYPES)) {
            return;
        }
        if ((text = text.trim()).length() == 0) {
            return;
        }
        if (text.charAt(0) == '+') {
            text = text.substring(1);
        }
        if (text.length() == 0) {
            return;
        }
        boolean hasLeadingOpenBracket = text.charAt(0) == '(';
        boolean bl = hasTrailingClosingBracket = text.charAt(text.length() - 1) == ')';
        if (hasLeadingOpenBracket && hasTrailingClosingBracket) {
            text = this.mFormatSymbols.getMinusSign() + text.substring(1, text.length() - 1);
        }
        if (null != (num = this.mFormat.parse(text, pos = new ParsePosition(0))) && pos.getIndex() == text.length()) {
            double dbl = num.doubleValue();
            if (Double.isNaN(dbl)) {
                DoubleValue v = ValueFactory.createDouble(dbl);
                v.setError();
                result.setValue(v);
            } else if (Double.isInfinite(dbl)) {
                DoubleValue v = ValueFactory.createDouble(dbl);
                v.setDivByZero();
                result.setValue(v);
            } else {
                int decimalSepPos = text.indexOf(this.mFormatSymbols.getDecimalSeparator());
                if (decimalSepPos != -1) {
                    result.setValue(ValueFactory.createDouble(dbl));
                } else {
                    result.setValue(ValueFactory.create(num));
                }
                boolean groupingSepFound = false;
                int groupingSepPos = text.indexOf(this.mFormatSymbols.getGroupingSeparator());
                if (groupingSepPos != -1 && groupingSepPos > 0 && groupingSepPos < text.length() - 1 && Character.isDigit(text.charAt(groupingSepPos - 1)) && Character.isDigit(text.charAt(groupingSepPos + 1))) {
                    groupingSepFound = true;
                    result.getDecorations().add(ValueDecorations.geThousandsSeparatorDecoration(this.mFormatSymbols.getGroupingSeparator()));
                }
                if (!groupingSepFound && this.mFormatSymbols.getGroupingSeparator() == '\u00a0' && (groupingSepPos = text.indexOf(32)) != -1 && groupingSepPos > 0 && groupingSepPos < text.length() - 1 && Character.isDigit(text.charAt(groupingSepPos - 1)) && Character.isDigit(text.charAt(groupingSepPos + 1))) {
                    groupingSepFound = true;
                    result.getDecorations().add(ValueDecorations.geThousandsSeparatorDecoration(this.mFormatSymbols.getGroupingSeparator()));
                }
            }
        }
    }

    static {
        NumberParser p = new NumberParser(ULocale.US);
        p.parse("1.23", new ParseResult());
        NUMBER_TYPES = EnumSet.of(BaseDataType.FLOAT, BaseDataType.DOUBLE, BaseDataType.INTEGER, BaseDataType.LONG, BaseDataType.DECIMAL);
    }
}

