/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract.parser;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.api.model.value.DoubleValue;
import com.ibm.cognos.aurora.api.model.value.ValueFactory;
import com.ibm.cognos.aurora.api.model.value.decor.ValueDecorations;
import com.ibm.cognos.aurora.core.extract.parser.ITextParser;
import com.ibm.cognos.aurora.core.extract.parser.ParseResult;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class PercentParser
implements ITextParser {
    private static final char NON_BREAK_SPACE = '\u00a0';
    private static final char BREAK_SPACE = ' ';
    private static EnumSet<BaseDataType> NUMBER_TYPES;
    private static final Set<Character> PERCENT_SYMBOLS;
    private final NumberFormat mFormat;
    private final DecimalFormatSymbols mFormatSymbols;

    public PercentParser(ULocale locale) {
        this.mFormat = NumberFormat.getPercentInstance((ULocale)locale);
        this.mFormat.setParseStrict(true);
        this.mFormatSymbols = ((DecimalFormat)this.mFormat).getDecimalFormatSymbols();
    }

    @Override
    public void parse(String text, ParseResult result) {
        this.parse(text, null, result);
    }

    @Override
    public void parse(String text, EnumSet<BaseDataType> tabooTypes, ParseResult result) {
        result.setValue(null);
        result.getDecorations().clear();
        if (null == text || text.length() == 0) {
            return;
        }
        if (null != tabooTypes && tabooTypes.containsAll(NUMBER_TYPES)) {
            return;
        }
        if ((text = text.trim()).length() == 0) {
            return;
        }
        if (text.charAt(0) == '+') {
            text = text.substring(1);
        }
        if (text.length() == 0) {
            return;
        }
        ParsePosition pos = new ParsePosition(0);
        Number num = this.mFormat.parse(text, pos);
        while (null == num || pos.getIndex() != text.length()) {
            if (pos.getErrorIndex() >= 0 && pos.getErrorIndex() < text.length() && text.charAt(pos.getErrorIndex()) == ' ') {
                StringBuilder buf = new StringBuilder(text);
                buf.setCharAt(pos.getErrorIndex(), '\u00a0');
                text = buf.toString();
            } else {
                if (pos.getErrorIndex() < 0 || pos.getErrorIndex() >= text.length() - 1 || text.charAt(pos.getErrorIndex()) != '\u00a0') break;
                DecimalFormatSymbols symbols = ((DecimalFormat)this.mFormat).getDecimalFormatSymbols();
                if (text.charAt(pos.getErrorIndex() + 1) != symbols.getPercent()) break;
                StringBuilder buf = new StringBuilder(text);
                buf.deleteCharAt(pos.getErrorIndex());
                text = buf.toString();
            }
            pos.setIndex(0);
            num = this.mFormat.parse(text, pos);
        }
        if (null != num && pos.getIndex() == text.length()) {
            double dbl = num.doubleValue();
            if (Double.isNaN(dbl)) {
                result.setValue(null);
            } else {
                DoubleValue v = ValueFactory.createDouble(dbl);
                if (Double.isInfinite(dbl)) {
                    v.setDivByZero();
                }
                result.setValue(v);
                result.getDecorations().add(ValueDecorations.getPercentDecoration(this.mFormatSymbols.getPercent()));
                boolean groupingSepFound = false;
                int groupingSepPos = text.indexOf(this.mFormatSymbols.getGroupingSeparator());
                if (groupingSepPos != -1 && groupingSepPos > 0 && groupingSepPos < text.length() - 1 && Character.isDigit(text.charAt(groupingSepPos - 1)) && Character.isDigit(text.charAt(groupingSepPos + 1))) {
                    groupingSepFound = true;
                    result.getDecorations().add(ValueDecorations.geThousandsSeparatorDecoration(this.mFormatSymbols.getGroupingSeparator()));
                }
                if (!groupingSepFound && this.mFormatSymbols.getGroupingSeparator() == '\u00a0' && (groupingSepPos = text.indexOf(32)) != -1 && groupingSepPos > 0 && groupingSepPos < text.length() - 1 && Character.isDigit(text.charAt(groupingSepPos - 1)) && Character.isDigit(text.charAt(groupingSepPos + 1))) {
                    groupingSepFound = true;
                    result.getDecorations().add(ValueDecorations.geThousandsSeparatorDecoration(this.mFormatSymbols.getGroupingSeparator()));
                }
            }
        }
    }

    public static Set<Character> getAllPercentSymbols() {
        return Collections.unmodifiableSet(PERCENT_SYMBOLS);
    }

    public static int findPercentSymbol(String text) {
        for (Character sym : PERCENT_SYMBOLS) {
            int index = text.indexOf(sym.charValue());
            if (index == -1) continue;
            return index;
        }
        return -1;
    }

    static {
        PercentParser p = new PercentParser(ULocale.US);
        p.parse("1.23%", new ParseResult());
        NUMBER_TYPES = EnumSet.of(BaseDataType.FLOAT, BaseDataType.DOUBLE, BaseDataType.INTEGER, BaseDataType.LONG, BaseDataType.DECIMAL);
        PERCENT_SYMBOLS = new HashSet<Character>();
        for (ULocale locale : DecimalFormatSymbols.getAvailableULocales()) {
            DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance((ULocale)locale);
            PERCENT_SYMBOLS.add(Character.valueOf(symbols.getPercent()));
        }
    }
}

