/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract.parser;

import com.ibm.cognos.aurora.api.model.datatype.BaseDataType;
import com.ibm.cognos.aurora.core.extract.parser.DateTimeParser;
import com.ibm.cognos.aurora.core.extract.parser.ParseResult;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import java.text.ParsePosition;
import java.util.EnumSet;

public class TimeParser
extends DateTimeParser {
    private final DateFormat[] mLocalizedFormats = new DateFormat[3];
    private final DateFormat mColon_HH_mm_ss_TZ;
    private final DateFormat mColon_HH_mm_ss_SS;
    private final DateFormat mColon_HH_mm_ss_SS_TZ;

    public TimeParser(ULocale locale) {
        super(locale);
        this.mLocalizedFormats[0] = DateFormat.getTimeInstance((Calendar)this.mLocalizedCalendar, (int)3, (ULocale)locale);
        this.mLocalizedFormats[1] = DateFormat.getTimeInstance((Calendar)this.mLocalizedCalendar, (int)2, (ULocale)locale);
        this.mLocalizedFormats[2] = DateFormat.getTimeInstance((Calendar)this.mLocalizedCalendar, (int)1, (ULocale)locale);
        this.mColon_HH_mm_ss_TZ = new SimpleDateFormat("HH:mm:ss z", locale);
        this.mColon_HH_mm_ss_TZ.setCalendar(this.mLocalizedCalendar);
        this.mColon_HH_mm_ss_SS = new SimpleDateFormat("HH:mm:ss.SS", locale);
        this.mColon_HH_mm_ss_SS.setCalendar(this.mLocalizedCalendar);
        this.mColon_HH_mm_ss_SS_TZ = new SimpleDateFormat("HH:mm:ss.SS z", locale);
        this.mColon_HH_mm_ss_SS_TZ.setCalendar(this.mLocalizedCalendar);
    }

    @Override
    public void parse(String text, EnumSet<BaseDataType> tabooTypes, ParseResult result) {
        ParsePosition pp;
        result.setValue(null);
        result.getDecorations().clear();
        if (null == text || text.length() == 0) {
            return;
        }
        if (null != tabooTypes && tabooTypes.contains((Object)BaseDataType.TIME)) {
            return;
        }
        if (this.parseISO8601Time(this.mISO8601_HH_mm_ss_S_Extended, text = text.trim(), pp = new ParsePosition(0), result)) {
            return;
        }
        if (this.parseISO8601Time(this.mISO8601_HH_mm_ss_Extended, text, pp, result)) {
            return;
        }
        if (this.parseISO8601Time(this.mISO8601_HH_mm_Extended, text, pp, result)) {
            return;
        }
        for (int i = 0; i < this.mLocalizedFormats.length; ++i) {
            DateFormat format = this.mLocalizedFormats[i];
            if (!this.parseLocalizedTime(format, text, pp, result)) continue;
            if (i > 0) {
                this.mLocalizedFormats[i] = this.mLocalizedFormats[i - 1];
                this.mLocalizedFormats[i - 1] = format;
            }
            return;
        }
        if (this.parseLocalizedTime(this.mColon_HH_mm_ss_TZ, text, pp, result)) {
            return;
        }
        if (this.parseLocalizedTime(this.mColon_HH_mm_ss_SS, text, pp, result)) {
            return;
        }
        if (this.parseLocalizedTime(this.mColon_HH_mm_ss_SS_TZ, text, pp, result)) {
            return;
        }
    }

    static {
        TimeParser p = new TimeParser(ULocale.US);
        p.parse("12:30:30", new ParseResult());
    }
}

