/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.extract.process;

import com.ibm.cognos.aurora.core.extract.TabularDataset;
import com.ibm.cognos.aurora.core.extract.process.ITabularDatasetProcessor;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LoggerManager;
import java.util.LinkedList;

public final class DropEmptyColumns
implements ITabularDatasetProcessor {
    private static final ILogger logger = LoggerManager.getLogger("ATHENA.core.aurora_core");

    @Override
    public void process(TabularDataset dataset) {
        LinkedList<TabularDataset.ColumnInfo> columnsToDrop = new LinkedList<TabularDataset.ColumnInfo>();
        for (TabularDataset.ColumnInfo colInfo : dataset.getColumns()) {
            if (colInfo.getNonNullCount() != 0L) continue;
            columnsToDrop.add(colInfo);
        }
        for (TabularDataset.ColumnInfo colInfo : columnsToDrop) {
            if (logger.isWarnEnabled()) {
                String msg = String.format("Dropping empty column (%s) from dataset '%s'", colInfo.getName(), dataset.getDatasetName());
                logger.warn(msg, this.getClass().getName() + "::process()");
            }
            dataset.removeColumn(colInfo.getName());
        }
    }
}

