/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.api;

import com.ibm.cognos.aurora.core.graph.api.IArc;
import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.util.collection.Filters;
import com.ibm.cognos.aurora.core.util.collection.IFilter;

public final class ArcFilters
extends Filters {
    public static IFilter<IArc> allTrue() {
        return ArcFilters.allTrue(IArc.class);
    }

    public static IFilter<IArc> allFalse() {
        return ArcFilters.allFalse(IArc.class);
    }

    public static IFilter<IArc> hasId(final int arcId) {
        return new IFilter<IArc>(){

            @Override
            public boolean passes(IArc arc) {
                return arc.getId() == arcId;
            }
        };
    }

    public static IFilter<IArc> hasLabel(final String ... labels) {
        return new IFilter<IArc>(){

            @Override
            public boolean passes(IArc arc) {
                if (null == labels || labels.length == 0) {
                    return true;
                }
                for (String label : labels) {
                    String arcLabel = arc.getLabel();
                    if (arcLabel == null || !arcLabel.equals(label)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static IFilter<IArc> hasStart(final IVertex start) {
        return new IFilter<IArc>(){

            @Override
            public boolean passes(IArc arc) {
                return arc.getStart().equals(start);
            }
        };
    }

    public static IFilter<IArc> hasStartId(final int startId) {
        return new IFilter<IArc>(){

            @Override
            public boolean passes(IArc arc) {
                return arc.getStart().getId() == startId;
            }
        };
    }

    public static IFilter<IArc> hasEnd(final IVertex end) {
        return new IFilter<IArc>(){

            @Override
            public boolean passes(IArc arc) {
                return arc.getEnd().equals(end);
            }
        };
    }

    public static IFilter<IArc> hasEndId(final int endId) {
        return new IFilter<IArc>(){

            @Override
            public boolean passes(IArc arc) {
                return arc.getEnd().getId() == endId;
            }
        };
    }

    public static IFilter<IArc> connects(IVertex start, IVertex end) {
        return ArcFilters.and(ArcFilters.hasStart(start), ArcFilters.hasEnd(end));
    }

    public static IFilter<IArc> connects(int startId, int endId) {
        return ArcFilters.and(ArcFilters.hasStartId(startId), ArcFilters.hasEndId(endId));
    }

    public static IFilter<IArc> connectsUndirected(IVertex start, IVertex end) {
        return ArcFilters.or(ArcFilters.connects(start, end), ArcFilters.connects(end, start));
    }

    public static IFilter<IArc> connectsUndirected(int startId, int endId) {
        return ArcFilters.or(ArcFilters.connects(startId, endId), ArcFilters.connects(endId, startId));
    }

    public static IFilter<IArc> startPasses(final IFilter<IVertex> vertexFilter) {
        return new IFilter<IArc>(){

            @Override
            public boolean passes(IArc arc) {
                return vertexFilter.passes(arc.getStart());
            }
        };
    }

    public static IFilter<IArc> endPasses(final IFilter<IVertex> vertexFilter) {
        return new IFilter<IArc>(){

            @Override
            public boolean passes(IArc arc) {
                return vertexFilter.passes(arc.getEnd());
            }
        };
    }

    public static IFilter<IArc> hasPropertyValue(final String propertyName, final Object propertyValue) {
        return new IFilter<IArc>(){

            @Override
            public boolean passes(IArc arc) {
                Object value = arc.getPropertyValue(propertyName);
                if (null == value) {
                    return null == propertyValue;
                }
                if (null == propertyValue) {
                    return false;
                }
                return value.equals(propertyValue);
            }
        };
    }

    private ArcFilters() {
    }
}

