/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.graph.impl.mem;

import com.ibm.cognos.aurora.core.graph.api.IArc;
import com.ibm.cognos.aurora.core.graph.api.IGraph;
import com.ibm.cognos.aurora.core.graph.api.IVertex;
import com.ibm.cognos.aurora.core.graph.impl.mem.InMemoryArc;
import com.ibm.cognos.aurora.core.graph.impl.mem.InMemoryGraph;
import com.ibm.cognos.aurora.core.graph.util.IndexedPropertyContainer;
import com.ibm.cognos.aurora.core.util.collection.DistinctIterable;
import com.ibm.cognos.aurora.core.util.collection.FilteringIterable;
import com.ibm.cognos.aurora.core.util.collection.Filters;
import com.ibm.cognos.aurora.core.util.collection.IFilter;
import com.ibm.cognos.aurora.core.util.collection.UnionIterable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

final class InMemoryVertex
extends IndexedPropertyContainer
implements IVertex {
    private final InMemoryGraph mGraph;
    private final int mId;
    private final List<IArc> mInArcs = new LinkedList<IArc>();
    private final List<IArc> mOutArcs = new LinkedList<IArc>();

    InMemoryVertex(InMemoryGraph graph, int id) {
        super(graph.mVertexPropIndex);
        this.mGraph = graph;
        this.mId = id;
    }

    @Override
    public IGraph getGraph() {
        return this.mGraph;
    }

    @Override
    public int getId() {
        return this.mId;
    }

    @Override
    public String getLabel() {
        return (String)this.getPropertyValue("label");
    }

    @Override
    public void setLabel(String label) {
        this.setPropertyValue("label", label);
    }

    @Override
    public Iterable<IArc> arcs() {
        return new UnionIterable<IArc>(this.inArcs(), this.outArcs());
    }

    @Override
    public Iterable<IArc> arcs(IFilter<IArc> filter) {
        return new UnionIterable<IArc>(this.inArcs(filter), this.outArcs(filter));
    }

    @Override
    public Iterable<IArc> inArcs() {
        return Collections.unmodifiableList(this.mInArcs);
    }

    @Override
    public Iterable<IArc> inArcs(IFilter<IArc> filter) {
        return new FilteringIterable<IArc>(this.inArcs(), filter);
    }

    @Override
    public Iterable<IArc> outArcs() {
        return Collections.unmodifiableList(this.mOutArcs);
    }

    @Override
    public Iterable<IArc> outArcs(IFilter<IArc> filter) {
        return new FilteringIterable<IArc>(this.outArcs(), filter);
    }

    @Override
    public Iterable<IVertex> neighbors() {
        return new DistinctIterable<IVertex>(new UnionIterable(this.inNeighbors(), this.outNeighbors()));
    }

    @Override
    public Iterable<IVertex> neighbors(IFilter<IArc> arcFilter, IFilter<IVertex> vertexFilter) {
        return new DistinctIterable<IVertex>(new UnionIterable(this.inNeighbors(arcFilter, vertexFilter), this.outNeighbors(arcFilter, vertexFilter)));
    }

    @Override
    public Iterable<IVertex> inNeighbors() {
        return this.inNeighbors(Filters.allTrue(IArc.class), Filters.allTrue(IVertex.class));
    }

    @Override
    public Iterable<IVertex> inNeighbors(final IFilter<IArc> arcFilter, IFilter<IVertex> vertexFilter) {
        return new DistinctIterable<IVertex>(new FilteringIterable<IVertex>(new Iterable<IVertex>(){

            @Override
            public Iterator<IVertex> iterator() {
                return new Iterator<IVertex>(){
                    final Iterator<IArc> mArcIter;
                    {
                        this.mArcIter = InMemoryVertex.this.inArcs(arcFilter).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mArcIter.hasNext();
                    }

                    @Override
                    public IVertex next() {
                        return this.mArcIter.next().getStart();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, vertexFilter));
    }

    @Override
    public Iterable<IVertex> outNeighbors() {
        return this.outNeighbors(Filters.allTrue(IArc.class), Filters.allTrue(IVertex.class));
    }

    @Override
    public Iterable<IVertex> outNeighbors(final IFilter<IArc> arcFilter, IFilter<IVertex> vertexFilter) {
        return new DistinctIterable<IVertex>(new FilteringIterable<IVertex>(new Iterable<IVertex>(){

            @Override
            public Iterator<IVertex> iterator() {
                return new Iterator<IVertex>(){
                    final Iterator<IArc> mArcIter;
                    {
                        this.mArcIter = InMemoryVertex.this.outArcs(arcFilter).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mArcIter.hasNext();
                    }

                    @Override
                    public IVertex next() {
                        return this.mArcIter.next().getEnd();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, vertexFilter));
    }

    void addInArc(InMemoryArc arc) {
        this.mInArcs.add(arc);
    }

    void addOutArc(InMemoryArc arc) {
        this.mOutArcs.add(arc);
    }

    void removeInArc(InMemoryArc arc) {
        this.mInArcs.remove(arc);
    }

    void removeOutArc(InMemoryArc arc) {
        this.mOutArcs.remove(arc);
    }

    void clearArcs() {
        this.mInArcs.clear();
        this.mOutArcs.clear();
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        tsb.append("id", this.mId);
        for (String key : this.getPropertyKeys()) {
            Object value = this.getPropertyValue(key);
            if (null == value) continue;
            tsb.append(key, value);
        }
        return tsb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IVertex)) {
            return false;
        }
        IVertex other = (IVertex)o;
        return this.getId() == other.getId();
    }

    @Override
    public int hashCode() {
        return this.getId();
    }
}

